<?php
/**
 * MASTER CORE V1 - HERO FADE EDITION (STROKE FIX)
 * Ubicación: /templates/default/Desing/hero.php
 */

$background_hero = $template_base . 'img/bg_hero.jpg'; 

require_once(__DIR__ . '/../../../config/settings.php'); 

try {
    $dsn = "dblib:host={$db_settings['host']};dbname={$db_settings['name']};charset=UTF8";
    $pdo_hero = new PDO($dsn, $db_settings['user'], $db_settings['pass']);
    $pdo_hero->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $stmt = $pdo_hero->query("SELECT setting_key, setting_value FROM Web_Settings");
    $web_data = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);

    $serverExp = $web_data['server_exp'] ?? "1000x";
    $heroLogo  = (!empty($web_data['web_logo_url'])) ? $web_data['web_logo_url'] : "logo-balduneta.png";

} catch (Exception $e) {
    $serverExp = "1000x";
    $heroLogo  = "logo-balduneta.png";
}
?>

<link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@700&display=swap" rel="stylesheet">

<section class="relative h-[75vh] md:h-[90vh] w-full flex items-center justify-center overflow-hidden bg-[#080101]">
    
    <div class="absolute inset-0 z-0">
        <div class="w-full h-full bg-cover bg-center bg-no-repeat" style="background-image: url('<?php echo $background_hero; ?>');"></div>
    </div>

    <div class="absolute inset-0 z-10 bg-black/40"></div>
    
    <div class="absolute inset-x-0 top-0 h-40 z-10 bg-gradient-to-b from-[#080101] to-transparent"></div>

    <div class="smoke-viewport">
        <div class="smoke-layer layer-1"></div>
        <div class="smoke-layer layer-2"></div>
        <div class="smoke-layer layer-3"></div>
    </div>

    <div class="absolute inset-x-0 bottom-0 h-64 z-20 bg-gradient-to-t from-[#080101] via-[#080101]/80 to-transparent"></div>
    
    <div class="absolute inset-0 z-10 bg-[radial-gradient(circle_at_center,rgba(139,0,0,0.2)_0%,transparent_70%)]"></div>

    <div class="relative z-30 text-center space-y-6 px-4 -mt-10">
        <div class="relative inline-block group">
            <div class="absolute inset-0 bg-red-600/20 blur-[120px] rounded-full animate-pulse"></div>
            <img src="<?php echo $heroLogo; ?>?v=<?php echo time(); ?>" alt="Logo" 
                 class="relative h-44 md:h-72 object-contain filter drop-shadow-[0_0_50px_rgba(255,0,0,0.6)] transition-transform duration-1000 hover:scale-110">
        </div>
        
        <div class="h-10 md:h-14 flex items-center justify-center overflow-hidden">
            <h2 id="dynamic-slogan" style="font-family: 'Cinzel', serif;" class="text-lg md:text-3xl text-white tracking-[0.3em] md:tracking-[0.5em] uppercase font-bold italic flex flex-wrap justify-center gap-x-6">
            </h2>
        </div>
        <div class="h-[2px] w-48 md:w-96 mx-auto bg-gradient-to-r from-transparent via-red-600 to-transparent shadow-[0_0_20px_rgba(255,0,0,1)]"></div>
    </div>
</section>

<div class="relative z-40 max-w-7xl mx-auto px-6 -mt-20 md:-mt-24 mb-16">
    <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
        
        <a href="descargas.php" class="btn-titan-container group">
            <div class="btn-titan-content bg-gradient-to-br from-[#8b0000] via-[#4a0000] to-black border-[#c5a059]">
                <div class="btn-titan-inner-border border-[#c5a059]">
                    <div class="btn-titan-icon border-[#c5a059]">
                        <i data-lucide="download" class="w-7 h-7 text-[#c5a059]"></i>
                    </div>
                    <div class="flex flex-col text-left">
                        <span class="text-[9px] text-[#c5a059] font-bold tracking-[3px] uppercase">Obtén el juego</span>
                        <h4 class="text-xl text-white font-black tracking-tight uppercase italic">Cliente Full</h4>
                    </div>
                </div>
                <div class="btn-titan-glow"></div>
            </div>
        </a>

        <a href="registro.php" class="btn-titan-container group">
            <div class="btn-titan-content bg-gradient-to-br from-[#c5a059] via-[#8b6b2d] to-[#4a3a14] border-[#8b0000]">
                <div class="btn-titan-inner-border border-[#8b0000]/50">
                    <div class="btn-titan-icon bg-red-900/30 border-[#8b0000]">
                        <i data-lucide="user-plus" class="w-7 h-7 text-white"></i>
                    </div>
                    <div class="flex flex-col text-left">
                        <span class="text-[9px] text-red-100 font-bold tracking-[3px] uppercase">Crea tu cuenta</span>
                        <h4 class="text-xl text-white font-black tracking-tight uppercase italic">Registro</h4>
                    </div>
                </div>
                <div class="btn-titan-glow bg-white/10"></div>
            </div>
        </a>

        <div class="btn-titan-container">
            <div class="btn-titan-content bg-gradient-to-br from-[#1a1a1a] via-[#0f0f0f] to-black border-[#c5a059]/30">
                <div class="btn-titan-inner-border border-[#c5a059]/30">
                    <div class="btn-titan-icon border-red-600/50">
                        <i data-lucide="zap" class="w-7 h-7 text-red-600 animate-pulse"></i>
                    </div>
                    <div class="flex flex-col text-left">
                        <span class="text-[9px] text-[#c5a059] font-bold tracking-[3px] uppercase">Servidor Global</span>
                        <h4 class="text-xl text-white font-black tracking-tight uppercase italic">Exp: <span class="text-red-500"><?php echo $serverExp; ?></span></h4>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<style>
    .btn-titan-container { position: relative; height: 90px; transition: all 0.4s ease; filter: drop-shadow(0 10px 15px rgba(0,0,0,0.5)); }
    .btn-titan-content { position: relative; height: 100%; width: 100%; border: 2px solid; clip-path: polygon(10% 0, 100% 0, 90% 100%, 0 100%); overflow: hidden; display: flex; align-items: center; padding: 0 30px; }
    .btn-titan-inner-border { width: 100%; height: 80%; border-left: 3px solid; display: flex; align-items: center; gap: 20px; padding-left: 15px; }
    .btn-titan-icon { width: 50px; height: 50px; background: rgba(0,0,0,0.6); border: 1px solid; display: flex; align-items: center; justify-content: center; transform: skewX(-15deg); }
    .btn-titan-icon i { transform: skewX(15deg); }
    .btn-titan-glow { position: absolute; top: 0; left: -100%; width: 100%; height: 100%; background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent); transition: 0.6s; }
    .btn-titan-container:hover { transform: translateY(-5px); filter: drop-shadow(0 15px 25px rgba(255,0,0,0.3)); }
    .btn-titan-container:hover .btn-titan-glow { left: 100%; }

    /* --- EFECTO DE HUMO GRIS MEJORADO --- */
    .smoke-viewport {
        position: absolute;
        bottom: 0;
        left: 0;
        width: 100%;
        height: 300px; /* Más alto para mayor densidad */
        z-index: 15;
        overflow: hidden;
        pointer-events: none;
    }

    .smoke-layer {
        position: absolute;
        bottom: 0;
        left: 0;
        width: 200%; /* El doble de ancho para el scroll infinito */
        height: 100%;
        background-image: url('https://i.imgur.com/OprsEDp.png'); /* Textura de nubes/humo */
        background-repeat: repeat-x;
        background-size: contain;
        transform: translate3d(0, 0, 0);
    }

    .layer-1 {
        animation: smoke-drift 30s linear infinite;
        opacity: 0.8;
        filter: grayscale(1) brightness(0.4);
    }

    .layer-2 {
        animation: smoke-drift 50s linear infinite reverse;
        opacity: 0.5;
        filter: grayscale(1) brightness(0.2) blur(5px);
        bottom: -20px;
    }

    .layer-3 {
        animation: smoke-drift 20s linear infinite;
        opacity: 0.4;
        filter: grayscale(1) brightness(0.6) blur(2px);
        bottom: -40px;
    }

    @keyframes smoke-drift {
        from { transform: translateX(0); }
        to { transform: translateX(-50%); }
    }

    /* --- RESTO DE ESTILOS ORIGINALES --- */
    .word-span { 
        display: inline-block; 
        position: relative; 
        opacity: 0; 
        transform: translateY(10px); 
        transition: all 0.8s ease;
        color: #ffffff; 
    }

    .word-span::before {
        content: attr(data-text);
        position: absolute;
        inset: 0;
        z-index: -1;
        -webkit-text-stroke: 2px transparent; 
        background: linear-gradient(to right, #4a0000 0%, #ff0000 25%, #ffffff 50%, #ff0000 75%, #4a0000 100%);
        background-size: 200% auto;
        -webkit-background-clip: text;
        background-clip: text;
        opacity: 0;
    }

    .word-span.visible { opacity: 1; transform: translateY(0); }
    .word-span.visible::before { 
        opacity: 1; 
        animation: flow-stroke 2s linear infinite; 
        filter: drop-shadow(0 0 5px red);
    }

    @keyframes flow-stroke { to { background-position: 200% center; } }

    .word-span.exit { opacity: 0; transform: translateY(-10px); filter: blur(5px); }
</style>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        const slogans = ["REINO DE TITANES", "EL DESPERTAR DEL DRAGÓN", "FORJA TU DESTINO ETERNO", "LA CRÓNICA FINAL EMPIEZA"];
        let currentSloganIndex = 0;
        const container = document.getElementById('dynamic-slogan');

        function displaySlogan(index) {
            container.innerHTML = '';
            const words = slogans[index].split(' ');
            words.forEach((word, i) => {
                const span = document.createElement('span');
                span.textContent = word; 
                span.setAttribute('data-text', word); 
                span.className = 'word-span';
                container.appendChild(span);
                setTimeout(() => span.classList.add('visible'), i * 150);
            });
            setTimeout(() => {
                const spans = container.querySelectorAll('.word-span');
                spans.forEach((span, i) => {
                    setTimeout(() => { span.classList.remove('visible'); span.classList.add('exit'); }, i * 80);
                });
            }, 3500); 
        }

        displaySlogan(currentSloganIndex);
        setInterval(() => {
            currentSloganIndex = (currentSloganIndex + 1) % slogans.length;
            displaySlogan(currentSloganIndex);
        }, 6000);

        if(typeof lucide !== 'undefined') lucide.createIcons();
    });
</script>