<?php
// 1. CARGAR CONFIGURACIÓN Y TEMPLATE ACTIVO
require_once('config/settings.php'); 
if (file_exists('active_template.php')) { 
    include 'active_template.php'; 
}

// 2. RUTA CORREGIDA: Header desde Desing
include('templates/' . ACTIVE_TEMPLATE . '/Desing/header.php'); 

$error = ""; 
$success = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user = trim($_POST['user']);
    $pass = trim($_POST['pass']);
    $mail = trim($_POST['mail']);

    if(strlen($user) < 4 || strlen($pass) < 4) {
        $error = "Usuario y clave deben tener al menos 4 caracteres.";
    } else {
        try {
            $dsn = "dblib:host={$db_settings['host']};dbname={$db_settings['name']};charset=UTF8";
            $pdo = new PDO($dsn, $db_settings['user'], $db_settings['pass']);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

            $check = $pdo->prepare("SELECT COUNT(*) FROM MEMB_INFO WHERE memb___id = ?");
            $check->execute([$user]);
            
            if ($check->fetchColumn() > 0) {
                $error = "El nombre de guerrero ya está en uso.";
            } else {
                $stmt = $pdo->prepare("INSERT INTO MEMB_INFO 
                    (memb___id, memb__pwd, memb_name, sno__numb, mail_addr, bloc_code, ctl1_code) 
                    VALUES (:user, :pass, :name, :sno, :mail, '0', '0')");
                
                $result = $stmt->execute([
                    ':user' => $user,
                    ':pass' => $pass,
                    ':name' => $user,
                    ':sno'  => '1111111111111',
                    ':mail' => $mail
                ]);

                if ($result) {
                    $success = "¡CUENTA FORJADA! Ya puedes ingresar al reino.";
                }
            }
        } catch (PDOException $e) {
            $error = "Error crítico de conexión.";
        }
    }
}
?>

<style>
    /* Estilos personalizados para el formulario Carnelian & Gold */
    .glass-mmo {
        background: rgba(10, 5, 5, 0.9);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 204, 51, 0.2);
    }
    .input-mmo {
        background: rgba(255, 255, 255, 0.03);
        border: 1px solid rgba(255, 204, 51, 0.1);
        color: white;
        transition: all 0.3s ease;
    }
    .input-mmo:focus {
        border-color: #ffcc33;
        box-shadow: 0 0 10px rgba(153, 0, 0, 0.5);
        outline: none;
    }
    .text-gold { color: #ffcc33; }
    .btn-register {
        background: linear-gradient(135deg, #990000 0%, #450a0a 100%);
        border: 1px solid #ffcc33;
        color: #ffcc33;
        transition: all 0.4s;
        text-shadow: 0 0 5px rgba(0,0,0,0.5);
    }
    .btn-register:hover {
        background: #dc2626;
        color: white;
        transform: scale(1.02);
        box-shadow: 0 0 20px rgba(153, 0, 0, 0.6);
    }
</style>

<div class="container mx-auto px-4 animate__animated animate__fadeIn" style="margin-top: 100px; margin-bottom: 80px;">
    <div class="max-w-md mx-auto glass-mmo p-8 rounded-sm shadow-[0_0_50px_rgba(0,0,0,0.5)] border-t-2 border-t-[#990000]">
        
        <div class="text-center mb-8">
            <h2 class="text-3xl font-bold text-gold font-title tracking-[5px] uppercase italic">Registro</h2>
            <div class="h-1 w-20 bg-[#990000] mx-auto mt-2"></div>
        </div>
        
        <?php if($error): ?> 
            <div class="bg-red-900/30 border border-red-600/50 text-red-200 p-4 mb-6 rounded-sm text-xs font-bold text-center">
                <i data-lucide="alert-circle" class="w-4 h-4 inline mr-2"></i> <?php echo $error; ?>
            </div> 
        <?php endif; ?>

        <?php if($success): ?> 
            <div class="bg-green-900/30 border border-green-500/50 text-green-200 p-6 mb-6 rounded-sm text-sm font-bold text-center uppercase tracking-widest">
                <i data-lucide="shield-check" class="w-8 h-8 mx-auto mb-2 text-green-400"></i><br>
                <?php echo $success; ?>
            </div> 
        <?php endif; ?>

        <form action="registro.php" method="POST" class="space-y-6 <?php if($success) echo 'hidden'; ?>">
            <div>
                <label class="block text-[10px] uppercase text-gold font-bold mb-2 tracking-widest">Identidad (Usuario)</label>
                <input type="text" name="user" placeholder="Mínimo 4 caracteres" required class="input-mmo w-full p-4 rounded-sm">
            </div>
            <div>
                <label class="block text-[10px] uppercase text-gold font-bold mb-2 tracking-widest">Sello Secreto (Clave)</label>
                <input type="password" name="pass" placeholder="••••••••" required class="input-mmo w-full p-4 rounded-sm">
            </div>
            <div>
                <label class="block text-[10px] uppercase text-gold font-bold mb-2 tracking-widest">Pergamíno de Contacto (E-Mail)</label>
                <input type="email" name="mail" placeholder="ejemplo@correo.com" required class="input-mmo w-full p-4 rounded-sm">
            </div>
            
            <button type="submit" class="btn-register w-full py-4 font-bold text-xs uppercase tracking-[0.4em]">
                FORJAR MI DESTINO
            </button>
        </form>
        
        <?php if($success): ?>
            <a href="index.php" class="btn-register block text-center w-full py-4 font-bold text-xs uppercase tracking-[0.4em]">
                VOLVER AL INICIO
            </a>
        <?php endif; ?>

        <div class="mt-8 text-center">
            <p class="text-[9px] text-gray-500 uppercase tracking-widest">Al registrarte aceptas las leyes del reino</p>
        </div>
    </div>
</div>

<?php 
// 3. FOOTER CORREGIDO: Ruta desde Desing
include('templates/' . ACTIVE_TEMPLATE . '/Desing/footer.php'); 
?>