<?php
session_start();
error_reporting(0); 

if (!isset($_SESSION['logged_in'])) { header("Location: index.php"); exit(); }
require_once(__DIR__ . '/config/settings.php');

// 1. DETERMINAR TEMPLATE ACTIVO (Lgica de Rutas Dinmicas)
if (file_exists('active_template.php')) { include 'active_template.php'; }
$template_path = 'templates/' . ACTIVE_TEMPLATE . '/Desing/';

// --- INTEGRACI07N DE CONFIGURACI07N DE MONEDA ---
$coin_config_file = __DIR__ . '/config/coin_settings.php';
if (file_exists($coin_config_file)) {
    include($coin_config_file);
} else {
    $coin_config = [
        'coin_name' => 'Credits',
        'coin_table' => 'MEMB_INFO',
        'coin_column' => 'cspoints',
        'coin_id_column' => 'memb___id'
    ];
}

// Mapeo de Clases para PHP (Mis Personajes)
$classIcons = [0=>'dw.jpg', 1=>'dw.jpg', 2=>'dw.jpg', 16=>'dk.jpg', 17=>'bk.jpg', 18=>'bm.jpg', 32=>'elf.jpg', 33=>'me.jpg', 34=>'he.jpg', 48=>'mg.jpg', 49=>'dm.jpg', 64=>'dl.jpg', 65=>'le.jpg'];

try {
    $host = $db_settings['host'];
    $dbname = $db_settings['name'];
    $user = $db_settings['user'];
    $pass = $db_settings['pass'];

    if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
        $pdo = new PDO("sqlsrv:Server=$host;Database=$dbname", $user, $pass);
    } else {
        $pdo = new PDO("dblib:host=$host;dbname=$dbname", $user, $pass);
    }
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Tambin cargamos la configuracin de PayPal
$stmtP = $pdo->query("SELECT setting_key, setting_value FROM Web_Settings WHERE setting_key LIKE 'paypal_%'");
$paypal_conf = $stmtP->fetchAll(PDO::FETCH_KEY_PAIR);

    $stmtM = $pdo->query("SELECT setting_key, setting_value FROM Web_Settings WHERE setting_key LIKE 'market_%'");
    $m_conf = $stmtM->fetchAll(PDO::FETCH_KEY_PAIR);
    
    // LEER CONFIGURACI07N DE PAYPAL DEL ADMIN
$stmtP = $pdo->query("SELECT setting_key, setting_value FROM Web_Settings WHERE setting_key LIKE 'paypal_%'");
$paypal_conf = $stmtP->fetchAll(PDO::FETCH_KEY_PAIR);

// Definir variables para usar en el HTML/JS
$admin_coin_rate = (float)($paypal_conf['paypal_coin_rate'] ?? 1); 
$admin_currency = $paypal_conf['paypal_currency'] ?? 'USD';
    
    $minResetsMarket = (int)($m_conf['market_min_resets'] ?? 0);
    $marketActive    = (int)($m_conf['market_active'] ?? 0);
    $valFull         = (int)($m_conf['market_full_val'] ?? 1000);
    $valReset        = (int)($m_conf['market_reset_val'] ?? 10);
    $maxStats         = (int)($m_conf['market_max_stats'] ?? 32767);

    $stmt = $pdo->prepare("SELECT Name, Class, cLevel, ResetCount, LevelUpPoint, Money, MapNumber, PkCount, Strength, Dexterity, Vitality, Energy, Leadership FROM Character WHERE AccountID = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $chars = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $cTable = $coin_config['coin_table'];
    $cCol   = $coin_config['coin_column'];
    $cIdCol = $coin_config['coin_id_column'];
    $stmtCoin = $pdo->prepare("SELECT $cCol FROM $cTable WHERE $cIdCol = ?");
    $stmtCoin->execute([$_SESSION['user_id']]);
    $coin_balance = $stmtCoin->fetchColumn() ?: 0;

    $stmtOnline = $pdo->prepare("SELECT ConnectStat FROM MEMB_STAT WHERE memb___id = ?");
    $stmtOnline->execute([$_SESSION['user_id']]);
    $isOnline = $stmtOnline->fetchColumn() == 1;

} catch (Exception $e) { 
    $chars = []; $coin_balance = 0; $isOnline = false;
}

// Cargar el Header dinmico
include($template_path . 'header.php');
?>

<style>
    #toast-notif { position: fixed; top: 25px; right: 25px; z-index: 9999; transform: translateX(150%); transition: transform 0.5s cubic-bezier(0.68, -0.55, 0.265, 1.55); }
    #toast-notif.active { transform: translateX(0); }
    .tab-content { display: none; }
    .tab-content.active { display: block; animation: fadeInUp 0.4s ease; }
    @keyframes fadeInUp { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }
    .stat-card { cursor: pointer; border: 1px solid rgba(255, 255, 255, 0.05); transition: 0.2s; position: relative; border-radius: 1.25rem; }
    .stat-card:hover { background: rgba(249, 115, 22, 0.05); border-color: rgba(249, 115, 22, 0.2); }
    .stat-card.selected { background: rgba(249, 115, 22, 0.1) !important; border-color: #f97316 !important; }
    .menu-btn.active { background: #f97316; color: white; }
    .coin-glow { position: relative; overflow: hidden; background: linear-gradient(135deg, rgba(249, 115, 22, 0.1) 0%, rgba(20, 20, 20, 0.4) 100%); border: 1px solid rgba(249, 115, 22, 0.3); box-shadow: 0 0 20px rgba(249, 115, 22, 0.1); animation: pulse-glow 3s infinite; }
    @keyframes pulse-glow { 0%, 100% { box-shadow: 0 0 15px rgba(249, 115, 22, 0.1); border-color: rgba(249, 115, 22, 0.3); } 50% { box-shadow: 0 0 30px rgba(249, 115, 22, 0.4); border-color: rgba(249, 115, 22, 0.6); } }
    
    .modal-market { position: fixed; inset: 0; background: rgba(0,0,0,0.85); backdrop-filter: blur(10px); z-index: 10000; display: none; align-items: center; justify-content: center; padding: 20px; }
    .modal-market.active { display: flex; animation: fadeIn 0.3s ease; }
    .modal-content { background: #0a0a0a; border: 1px solid rgba(249, 115, 22, 0.3); width: 100%; max-width: 500px; border-radius: 2rem; overflow: hidden; }
    .market-card { background: linear-gradient(180deg, rgba(255,255,255,0.02) 0%, rgba(0,0,0,0.4) 100%); border: 1px solid rgba(255,255,255,0.05); transition: 0.3s; }

    .inv-visual-container { display: grid; grid-template-columns: repeat(3, 1fr); gap: 6px; background: rgba(0,0,0,0.4); padding: 10px; border-radius: 1.5rem; border: 1px solid rgba(255,255,255,0.05); }
    .inv-visual-slot { aspect-ratio: 1/1; background: rgba(255,255,255,0.02); border: 1px solid rgba(255,255,255,0.05); border-radius: 0.75rem; display: flex; align-items: center; justify-content: center; position: relative; transition: 0.3s; }
    .inv-visual-slot img { width: 80%; height: 80%; object-fit: contain; }
    .inv-visual-lvl { position: absolute; bottom: 1px; right: 1px; font-size: 8px; font-weight: 900; background: rgba(0,0,0,0.8); color: #fff; padding: 0 4px; border-radius: 3px; z-index: 2; }
    
    /* Brillos de items corregidos */
    .exe-glow { border: 1px solid #22c55e !important; box-shadow: inset 0 0 10px rgba(34, 197, 94, 0.4), 0 0 8px rgba(34, 197, 94, 0.2); }
    .exe-glow img { filter: drop-shadow(0 0 5px rgba(34, 197, 94, 0.6)); }

    .anc-glow { border: 1px solid #3b82f6 !important; box-shadow: inset 0 0 15px rgba(59, 130, 246, 0.5), 0 0 10px rgba(59, 130, 246, 0.3) !important; }
    .anc-glow img { filter: drop-shadow(0 0 5px rgba(59, 130, 246, 0.8)); }

    .sock-glow { border: 1px solid #a855f7 !important; box-shadow: inset 0 0 15px rgba(168, 85, 247, 0.6), 0 0 15px rgba(168, 85, 247, 0.4) !important; }
    .sock-glow img { filter: drop-shadow(0 0 5px rgba(168, 85, 247, 0.8)); }

    .inv-visual-slot[data-tooltip]:hover::after {
        content: attr(data-tooltip);
        position: absolute;
        bottom: 115%;
        left: 50%;
        transform: translateX(-50%);
        background: rgba(0, 0, 0, 0.95);
        color: #fff; 
        padding: 8px 12px;
        border-radius: 8px;
        font-size: 10px;
        font-weight: bold;
        white-space: pre-wrap;
        z-index: 9999;
        border: 1px solid rgba(255,255,255,0.2);
        box-shadow: 0 10px 20px rgba(0,0,0,0.8);
        pointer-events: none;
        width: max-content;
        min-width: 100px;
        text-align: center;
    }
</style>

<div id="toast-notif" class="glass p-5 rounded-3xl border border-white/10 shadow-2xl flex items-center gap-4 min-w-[280px]">
    <div id="toast-status" class="w-10 h-10 rounded-full flex items-center justify-center">
        <i id="toast-icon" data-lucide="info" class="w-5 h-5 text-white"></i>
    </div>
    <div>
        <h4 id="toast-title" class="text-[10px] font-black uppercase text-white tracking-widest">Sistema</h4>
        <p id="toast-msg" class="text-[11px] text-gray-400 font-medium"></p>
    </div>
</div>

<div id="modalSell" class="modal-market">
    <div class="modal-content animate-in zoom-in duration-300">
        <div class="p-8 border-b border-white/5 bg-orange-600/5 text-center">
            <h3 class="text-xl font-black text-white uppercase tracking-tighter">Publicar <span class="text-orange-500">Personaje</span></h3>
            <p class="text-[10px] text-gray-400 uppercase font-bold tracking-widest">Valuacin automtica de mercado</p>
        </div>
        <div class="p-8 space-y-6">
            <div class="flex justify-between items-center bg-white/5 p-5 rounded-2xl border border-white/5">
                <div>
                    <p class="text-[9px] text-gray-500 uppercase font-black">Precio Estimado</p>
                    <h4 id="modalPriceDisplay" class="text-2xl font-black text-white tracking-tighter">0</h4>
                </div>
                <div class="text-right">
                    <p class="text-[9px] text-orange-500 uppercase font-black">Divisa</p>
                    <p class="text-xs font-bold text-white uppercase"><?php echo $coin_config['coin_name']; ?></p>
                </div>
            </div>
            <div class="bg-red-600/5 border border-red-600/20 p-5 rounded-2xl text-[11px] text-gray-400 italic">
                IMPORTANTE: Al venderlo, el personaje desaparecer de tu cuenta y el espacio quedar libre en el cliente.
            </div>
            <div class="flex gap-4">
                <button onclick="closeSellModal()" class="flex-1 py-4 text-[10px] font-black uppercase text-gray-500">Cancelar</button>
                <button id="confirmSellBtn" class="flex-[2] bg-orange-600 py-4 rounded-xl text-white text-[10px] font-black uppercase shadow-lg shadow-orange-600/20">Confirmar Venta</button>
            </div>
        </div>
    </div>
</div>

<div id="modalBuy" class="modal-market">
    <div class="modal-content animate-in zoom-in duration-300">
        <div class="p-8 border-b border-white/5 bg-green-600/5 text-center">
            <h3 class="text-xl font-black text-white uppercase">Confirmar <span class="text-green-500">Compra</span></h3>
        </div>
        <div class="p-8 space-y-6 text-center">
            <h4 id="buyCharName" class="text-3xl font-black text-white uppercase">NOMBRE</h4>
            <div class="bg-white/5 p-5 rounded-2xl border border-white/5 flex justify-between items-center">
                <div class="text-left">
                    <p class="text-[9px] text-gray-500 uppercase font-black">Precio</p>
                    <h4 id="buyPriceDisplay" class="text-2xl font-black text-white">0</h4>
                </div>
                <div class="text-right text-xs font-bold text-white uppercase">
                    <?php echo $coin_config['coin_name']; ?>
                </div>
            </div>
            <div class="flex gap-4">
                <button onclick="closeBuyModal()" class="flex-1 py-4 text-[10px] font-black uppercase text-gray-500">Volver</button>
                <button id="confirmBuyBtn" class="flex-[2] bg-green-600 py-4 rounded-xl text-white text-[10px] font-black uppercase shadow-lg shadow-green-600/20">Confirmar Pago</button>
            </div>
        </div>
    </div>
</div>
<div class="container mx-auto px-4 py-24">
    <div class="flex flex-col lg:flex-row gap-8">
        <aside class="w-full lg:w-80">
            <div class="glass p-8 rounded-[2rem] border border-white/10 text-center shadow-2xl">
                <div class="relative w-32 h-32 mx-auto mb-6">
                    <img id="user-avatar" src="assets/avatars/<?php echo $_SESSION['user_id']; ?>.jpg" onerror="this.src='https://ui-avatars.com/api/?name=<?php echo $_SESSION['user_id']; ?>&background=111&color=f97316'" class="w-full h-full rounded-full object-cover border-4 border-orange-500 shadow-2xl">
                    <button onclick="document.getElementById('file-input').click()" class="absolute bottom-0 right-0 bg-orange-600 p-3 rounded-full text-white hover:bg-orange-500 transition shadow-lg"><i data-lucide="camera" class="w-4 h-4"></i></button>
                    <input type="file" id="file-input" class="hidden" accept="image/*" onchange="uploadAvatar(this)">
                </div>
                <h2 class="text-xl font-black text-white uppercase mb-4"><?php echo $_SESSION['user_id']; ?></h2>
                <div class="coin-glow p-4 rounded-2xl mb-6">
                    <div class="flex items-center justify-center gap-3">
                        <div class="bg-orange-500/20 p-2 rounded-lg"><i data-lucide="coins" class="w-5 h-5 text-orange-500"></i></div>
                        <div class="text-left">
                            <p class="text-[9px] font-black text-orange-500 uppercase tracking-tighter italic">Balance de <?php echo htmlspecialchars($coin_config['coin_name']); ?></p>
                            <h3 class="text-2xl font-black text-white tracking-tight leading-none"><?php echo number_format($coin_balance); ?></h3>
                        </div>
                    </div>
                </div>
                <nav class="mt-8 space-y-3">
                    <button onclick="switchTab('chars', this)" class="menu-btn active w-full py-4 px-6 rounded-2xl flex items-center gap-4 text-[10px] font-bold uppercase tracking-widest transition-all border border-white/5"><i data-lucide="shield" class="w-5 h-5"></i> Personajes</button>
                    <button onclick="switchTab('market_list', this)" class="menu-btn w-full py-4 px-6 rounded-2xl flex items-center gap-4 text-[10px] font-bold uppercase tracking-widest transition-all border border-white/5"><i data-lucide="shopping-cart" class="w-5 h-5 text-orange-500"></i> Mercado de Personajes</button>
                    <button onclick="switchTab('donate_section', this)" class="menu-btn w-full py-4 px-6 rounded-2xl flex items-center gap-4 text-[10px] font-bold uppercase tracking-widest transition-all border border-white/5"><i data-lucide="credit-card" class="w-5 h-5 text-green-500"></i> Comprar <?php echo $coin_config['coin_name']; ?></button>
                </nav>
            </div>
        </aside>

        <main class="flex-1">
            <div id="chars" class="tab-content active">
                <div class="grid grid-cols-1 xl:grid-cols-2 gap-6">
                    <?php foreach($chars as $c): 
                        $canSell = ($c['ResetCount'] >= $minResetsMarket && $marketActive == 1);
                    ?>
                    <div id="char-card-<?php echo $c['Name']; ?>" class="glass rounded-[2rem] border border-white/5 overflow-hidden shadow-xl bg-black/10">
                        <div class="p-6 bg-white/5 flex items-center gap-4 border-b border-white/5">
                            <div class="w-14 h-14 rounded-2xl overflow-hidden border border-orange-500/30 bg-black">
                                <img src="assets/classes/<?php echo $classIcons[$c['Class']] ?? 'default.jpg'; ?>" class="w-full h-full object-cover">
                            </div>
                            <div class="flex-1">
                                <h3 class="text-lg font-black text-white uppercase"><?php echo $c['Name']; ?></h3>
                                <p class="text-[9px] text-gray-500 font-bold uppercase">Nivel <?php echo $c['cLevel']; ?> | Resets <?php echo $c['ResetCount']; ?></p>
                            </div>
                        </div>
                        <div class="p-6 grid grid-cols-2 gap-3" id="grid-<?php echo $c['Name']; ?>">
                            <div onclick="selectStat('<?php echo $c['Name']; ?>', 'Strength', this, 'Fuerza')" class="stat-card p-4 bg-white/5">
                                <span class="text-[9px] text-gray-500 uppercase font-bold block mb-1">Fuerza</span>
                                <span class="text-white font-black stat-val" data-stat="Strength"><?php echo $c['Strength']; ?></span>
                            </div>
                            <div onclick="selectStat('<?php echo $c['Name']; ?>', 'Dexterity', this, 'Agilidad')" class="stat-card p-4 bg-white/5">
                                <span class="text-[9px] text-gray-500 uppercase font-bold block mb-1">Agilidad</span>
                                <span class="text-white font-black stat-val" data-stat="Dexterity"><?php echo $c['Dexterity']; ?></span>
                            </div>
                            <div onclick="selectStat('<?php echo $c['Name']; ?>', 'Vitality', this, 'Vitalidad')" class="stat-card p-4 bg-white/5">
                                <span class="text-[9px] text-gray-500 uppercase font-bold block mb-1">Vitalidad</span>
                                <span class="text-white font-black stat-val" data-stat="Vitality"><?php echo $c['Vitality']; ?></span>
                            </div>
                            <div onclick="selectStat('<?php echo $c['Name']; ?>', 'Energy', this, 'Energ&iacute;a')" class="stat-card p-4 bg-white/5">
                                <span class="text-[9px] text-gray-500 uppercase font-bold block mb-1">Energ&iacute;a</span>
                                <span class="text-white font-black stat-val" data-stat="Energy"><?php echo $c['Energy']; ?></span>
                            </div>
                        </div>
                        <div class="p-6 bg-white/5 border-t border-white/5">
                            <div class="flex justify-between items-center mb-4">
                                <span id="label-<?php echo $c['Name']; ?>" class="text-[10px] text-orange-500 font-black uppercase italic tracking-tighter">Selecciona Atributo</span>
                                <span class="text-[10px] text-white font-bold uppercase">Libres: <b class="points-free"><?php echo $c['LevelUpPoint']; ?></b></span>
                            </div>
                            <div class="flex gap-2">
                                <input type="hidden" id="key-<?php echo $c['Name']; ?>"><input type="number" id="val-<?php echo $c['Name']; ?>" placeholder="0" class="flex-1 bg-black/40 border border-white/10 rounded-xl p-3 text-white outline-none focus:border-orange-500 transition-all">
                                <button onclick="sendPoints('<?php echo $c['Name']; ?>')" class="bg-orange-600 p-4 rounded-xl text-white hover:bg-orange-500 transition btn-add"><i data-lucide="plus" class="w-5 h-5"></i></button>
                            </div>
                            <div class="flex gap-2 mt-4">
                                <button onclick="doAction('<?php echo $c['Name']; ?>', 'reset')" class="flex-1 bg-blue-600/20 border border-blue-500/30 py-3 rounded-xl text-blue-400 text-[10px] font-black uppercase tracking-widest hover:bg-blue-600 hover:text-white transition-all">Resetear</button>
                                <button onclick="doAction('<?php echo $c['Name']; ?>', 'mreset')" class="flex-1 bg-purple-600/20 border border-purple-500/30 py-3 rounded-xl text-purple-400 text-[10px] font-black uppercase tracking-widest hover:bg-purple-600 hover:text-white transition-all">Master Reset</button>
                            </div>
                            <div class="mt-2">
                                <?php if($canSell): ?>
                                    <button onclick="openSellModal('<?php echo $c['Name']; ?>', <?php echo $c['ResetCount']; ?>, <?php echo $c['Strength']; ?>, <?php echo $c['Dexterity']; ?>, <?php echo $c['Vitality']; ?>, <?php echo $c['Energy']; ?>, <?php echo $c['Class']; ?>, <?php echo $c['cLevel']; ?>)" class="w-full bg-orange-600/10 border border-orange-500/30 py-4 rounded-xl text-orange-500 text-[10px] font-black uppercase tracking-widest hover:bg-orange-600 hover:text-white transition-all">Vender Personaje</button>
                                <?php else: ?>
                                    <button disabled class="w-full bg-white/5 border border-white/10 py-4 rounded-xl text-gray-600 text-[10px] font-black uppercase tracking-widest cursor-not-allowed italic">M&iacute;nimo <?php echo $minResetsMarket; ?> Resets</button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <div id="market_list" class="tab-content">
                <div class="mb-10"><h2 class="text-4xl font-black text-white uppercase italic tracking-tighter">Mercado <span class="text-orange-500">Global</span></h2><p class="text-gray-500 text-[10px] font-bold uppercase tracking-widest">Guerreros en busca de un nuevo due&ntilde;o</p></div>
                <div id="market-grid" class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-6"></div>
            </div>
            <div id="donate_section" class="tab-content">
    <div class="mb-10">
        <h2 class="text-4xl font-black text-white uppercase italic tracking-tighter">Recargar <span class="text-green-500"><?php echo $coin_config['coin_name']; ?></span></h2>
        <p class="text-gray-500 text-[10px] font-bold uppercase tracking-widest">Obten moneda virtual de forma inmediata via PayPal</p>
    </div>

    <div class="max-w-md mx-auto glass p-8 rounded-[2rem] border border-white/10 shadow-2xl bg-black/20">
        <div class="space-y-6">
            <div>
                <label class="text-[10px] font-black text-gray-500 uppercase mb-2 block">Cantidad de <?php echo $coin_config['coin_name']; ?> a comprar</label>
                <input type="number" id="input_coins" oninput="calculateDonation()" placeholder="Ej: 1000" class="w-full bg-black/40 border border-white/10 rounded-2xl p-4 text-white text-xl font-black outline-none focus:border-green-500 transition-all">
            </div>

            <div class="bg-white/5 p-6 rounded-2xl border border-white/5 space-y-3">
                <div class="flex justify-between items-center">
                    <span class="text-[10px] text-gray-400 font-bold uppercase">Costo Total:</span>
                    <span id="display_cost" class="text-2xl font-black text-white">0.00</span>
                </div>
                <div class="flex justify-between items-center border-t border-white/5 pt-3">
                    <span class="text-[10px] text-gray-400 font-bold uppercase">Moneda:</span>
                    <span class="text-xs font-bold text-green-500 uppercase"><?php echo $db_conf['paypal_currency'] ?? 'USD'; ?></span>
                </div>
            </div>

            <div id="paypal-button-container" class="mt-4"></div>
            
            <p class="text-[9px] text-gray-500 italic text-center uppercase font-medium">
                Al comprar, aceptas los t&eacute;rminos y condiciones. La acreditaci&oacute;n es autom&aacute;tica.
            </p>
        </div>
    </div>
</div>
        </main>
    </div>
</div>

<script>
const isOnline = <?php echo $isOnline ? 'true' : 'false'; ?>;
const myAcc = "<?php echo $_SESSION['user_id']; ?>";

// --- CONFIGURACI07N DIN09MICA DE PAYPAL (DESDE EL ADMIN) ---
// Usamos paypal_conf o db_conf segn lo que tengas cargado en PHP
const paypalRate = <?php echo (float)($paypal_conf['paypal_coin_rate'] ?? $db_conf['paypal_coin_rate'] ?? 1); ?>; 
const paypalCurrency = "<?php echo $paypal_conf['paypal_currency'] ?? $db_conf['paypal_currency'] ?? 'USD'; ?>";
const minPurchase = <?php echo (float)($paypal_conf['paypal_min_purchase'] ?? $db_conf['paypal_min_purchase'] ?? 1); ?>;
const paypalClientId = "<?php echo $paypal_conf['paypal_client_id'] ?? $db_conf['paypal_client_id'] ?? ''; ?>";

// CONFIGURACI07N DE CLASES PARA EL MERCADO
const classImages = {
    0: 'dw.jpg', 1: 'dw.jpg', 2: 'dw.jpg', 3: 'dw.jpg',
    16: 'dk.jpg', 17: 'bk.jpg', 18: 'bm.jpg', 19: 'bm.jpg',
    32: 'elf.jpg', 33: 'me.jpg', 34: 'he.jpg', 35: 'he.jpg',
    48: 'mg.jpg', 49: 'dm.jpg',
    64: 'dl.jpg', 65: 'le.jpg',
    80: 'sum.jpg', 81: 'sum.jpg',
    96: 'rf.jpg', 97: 'rf.jpg'
};

const config = { 
    valFull: <?php echo $valFull; ?>, 
    valReset: <?php echo $valReset; ?>, 
    maxStats: <?php echo $maxStats; ?> 
};

// --- FUNCI07N DE C09LCULO DE DONACI07N CORREGIDA ---
function calculateDonation() {
    const inputCoins = document.getElementById('input_coins');
    const displayCost = document.getElementById('display_cost');
    let coins = parseFloat(inputCoins.value) || 0;
    
    // Multiplicacin: Monedas x Valor configurado en Admin
    let totalCost = (coins * paypalRate).toFixed(2);
    displayCost.innerText = totalCost + " " + paypalCurrency;
    return totalCost;
}

// --- FUNCI07N PARA PROCESAR EL PAGO EN EL SERVIDOR ---
function procesarEntregaMonedas(orderID, cantidad) {
    const fd = new FormData();
    fd.append('order_id', orderID);
    fd.append('coins', cantidad);

    fetch('api_paypal_process.php', { method: 'POST', body: fd })
    .then(r => r.json())
    .then(data => {
        if(data.success) {
            notify('0307xito!', 'Pago confirmado. Monedas entregadas.', 'success');
            setTimeout(() => location.reload(), 2000);
        } else {
            notify('Error', 'Pago recibido pero hubo un error al acreditar: ' + data.message, 'error');
        }
    });
}

// --- L07GICA DE RENDERIZADO DEL BOT07N DE PAYPAL ---
if (paypalClientId) {
    const script = document.createElement('script');
    script.src = `https://www.paypal.com/sdk/js?client-id=${paypalClientId}&currency=${paypalCurrency}`;
    script.onload = function() {
        paypal.Buttons({
            style: { layout: 'vertical', color: 'gold', shape: 'rect', label: 'pay' },
            createOrder: function(data, actions) {
                let cost = calculateDonation();
                if (parseFloat(cost) < minPurchase) {
                    notify('Monto Insuficiente', 'Mnimo: ' + minPurchase + ' ' + paypalCurrency, 'error');
                    return false;
                }
                return actions.order.create({
                    purchase_units: [{ amount: { value: cost } }]
                });
            },
            onApprove: function(data, actions) {
                return actions.order.capture().then(function(details) {
                    const cant = document.getElementById('input_coins').value;
                    procesarEntregaMonedas(details.id, cant);
                });
            }
        }).render('#paypal-button-container');
    };
    document.head.appendChild(script);
}

// --- TUS FUNCIONES EXISTENTES (SIN CAMBIOS) ---
function renderVisualEquipment(equipment) {
    let html = '<div class="inv-visual-container mt-4">';
    for (let i = 0; i <= 11; i++) {
        const item = (equipment || []).find(e => e.slot === i);
        if (item) {
            let glowClass = "";
            let typeTitle = "ITEM NORMAL";
            if (item.isSock) { glowClass = "sock-glow"; typeTitle = "ITEM SOCKET"; }
            else if (item.isAnc) { glowClass = "anc-glow"; typeTitle = "ITEM ANCIENT"; }
            else if (item.isExe) { glowClass = "exe-glow"; typeTitle = "ITEM EXCELENTE"; }
            let fullTooltip = `${typeTitle}\nNivel: +${item.lvl}\n${item.opts || ''}`;
            html += `<div class="inv-visual-slot ${glowClass}" data-tooltip="${fullTooltip}"><img src="${item.img}" onerror="this.src='assets/items/no-item.png'"><span class="inv-visual-lvl">+${item.lvl}</span></div>`;
        } else { html += `<div class="inv-visual-slot opacity-20"></div>`; }
    }
    html += '</div>';
    return html;
}

function openSellModal(name, resets, str, agi, vit, ene, charClass, level) {
    if(isOnline) { notify('Cuenta Conectada', 'Descon&eacute;ctate para vender.', 'error'); return; }
    let totalStats = parseInt(str) + parseInt(agi) + parseInt(vit) + parseInt(ene);
    let statsFactor = totalStats / (config.maxStats * 4);
    let precioTotal = Math.round((config.valFull * (statsFactor > 1 ? 1 : statsFactor)) + (resets * config.valReset));
    document.getElementById('modalPriceDisplay').innerText = precioTotal.toLocaleString();
    document.getElementById('modalSell').classList.add('active');
    document.getElementById('confirmSellBtn').onclick = () => { confirmarVenta(name, precioTotal, str, agi, vit, ene, charClass, level); };
}

function confirmarVenta(name, precio, str, agi, vit, ene, charClass, level) {
    closeSellModal();
    const fd = new FormData();
    fd.append('action', 'sell'); fd.append('char', name); fd.append('price', precio);
    fd.append('str', str); fd.append('agi', agi); fd.append('vit', vit); fd.append('ene', ene);
    fd.append('class', charClass); fd.append('level', level);
    fetch('api_market_action.php', { method: 'POST', body: fd }).then(r => r.json()).then(data => {
        if(data.success) { notify('&Eacute;xito', 'Personaje movido al mercado.'); setTimeout(() => location.reload(), 1500); }
        else { notify('Error', data.message, 'error'); }
    });
}

function closeSellModal() { document.getElementById('modalSell').classList.remove('active'); }

function openBuyModal(name, price, id_venta) {
    if(isOnline) { notify('Cuenta Conectada', 'Descon&eacute;ctate para comprar.', 'error'); return; }
    document.getElementById('buyCharName').innerText = name;
    let cleanPrice = price.toString().replace(/,/g, '');
    document.getElementById('buyPriceDisplay').innerText = parseInt(cleanPrice).toLocaleString();
    document.getElementById('modalBuy').classList.add('active');
    document.getElementById('confirmBuyBtn').onclick = () => { ejecutarCompra(id_venta); };
}
function closeBuyModal() { document.getElementById('modalBuy').classList.remove('active'); }

function fetchMarketItems() {
    const grid = document.getElementById('market-grid');
    grid.innerHTML = '<div class="col-span-full py-10 text-center text-gray-500 animate-pulse uppercase text-[10px] font-bold">Cargando mercado...</div>';
    fetch('api_get_market.php').then(r => r.json()).then(data => {
        grid.innerHTML = '';
        if(!data || data.length === 0) {
            grid.innerHTML = '<div class="col-span-full py-20 text-center bg-white/5 rounded-3xl border border-white/5 text-gray-500 font-black uppercase text-xs tracking-widest">Sin personajes en venta</div>';
            return;
        }
        data.forEach(item => {
            const isMine = (item.seller_id === myAcc);
            const classId = parseInt(item.char_class);
            const classIcon = classImages[classId] || 'default.jpg';
            const str = item.char_str || 0; const agi = item.char_agi || 0;
            const vit = item.char_vit || 0; const ene = item.char_ene || 0;
            const price = item.price || 0; const idVenta = item.id || 0;
            const resets = item.char_resets || 0; const equipmentHtml = renderVisualEquipment(item.equipment);
            const btnHtml = isMine 
                ? `<div class="group relative"><button disabled class="w-full bg-white/5 text-gray-600 py-3 rounded-xl font-black text-[9px] uppercase italic border border-white/10">Tu personaje</button><div class="absolute inset-0 bg-red-600 text-white rounded-xl flex items-center justify-center opacity-0 group-hover:opacity-100 transition duration-300 text-[8px] font-black uppercase px-2 text-center">No puedes comprarte a ti mismo</div></div>`
                : `<button onclick="openBuyModal('${item.char_name}', '${price}', ${idVenta})" class="w-full bg-white text-black py-3 rounded-xl font-black text-[10px] uppercase hover:bg-orange-500 hover:text-white transition-all shadow-lg">Comprar</button>`;

            grid.innerHTML += `<div class="market-card p-6 rounded-[2rem] space-y-4 border border-white/5"><div class="flex items-center gap-4"><img src="assets/classes/${classIcon}" onerror="this.src='assets/classes/default.jpg'" class="w-12 h-12 rounded-xl border border-orange-500/30 bg-black"><div><h4 class="text-white font-black uppercase text-sm">${item.char_name}</h4><p class="text-[9px] text-orange-500 font-bold uppercase">Resets: ${resets}</p></div></div>${equipmentHtml}<div class="grid grid-cols-2 gap-2 bg-black/40 p-3 rounded-2xl border border-white/5"><div class="text-[8px] font-bold text-gray-500 uppercase">STR: <span class="text-white">${str}</span></div><div class="text-[8px] font-bold text-gray-500 uppercase">AGI: <span class="text-white">${agi}</span></div><div class="text-[8px] font-bold text-gray-500 uppercase">VIT: <span class="text-white">${vit}</span></div><div class="text-[8px] font-bold text-gray-500 uppercase">ENE: <span class="text-white">${ene}</span></div></div><div class="flex items-center justify-between pt-2"><p class="text-[8px] text-gray-500 font-bold uppercase">Vendedor: ${item.seller_id}</p><span class="text-orange-500 font-black text-sm">${parseInt(price).toLocaleString()}</span></div>${btnHtml}</div>`;
        });
        if(typeof lucide !== 'undefined') lucide.createIcons();
    }).catch(err => {
        grid.innerHTML = '<div class="col-span-full py-10 text-center text-red-500 font-bold uppercase text-[10px]">Error al cargar mercado</div>';
    });
}

function ejecutarCompra(id_venta) {
    closeBuyModal();
    const fd = new FormData(); fd.append('action', 'buy'); fd.append('market_id', id_venta);
    fetch('api_market_action.php', { method: 'POST', body: fd }).then(r => r.json()).then(data => {
        if(data.success) { notify('&iexcl;Comprado!', 'Personaje enviado a tu cuenta.'); setTimeout(() => location.reload(), 1500); }
        else { notify('Error', data.message, 'error'); }
    });
}

function switchTab(id, btn) {
    document.querySelectorAll('.tab-content').forEach(t => t.classList.remove('active'));
    document.querySelectorAll('.menu-btn').forEach(b => b.classList.remove('active'));
    document.getElementById(id).classList.add('active');
    btn.classList.add('active');
    if(id === 'market_list') fetchMarketItems();
}

function selectStat(name, key, el, label) {
    document.querySelectorAll(`#grid-${name} .stat-card`).forEach(c => c.classList.remove('selected'));
    el.classList.add('selected');
    document.getElementById(`key-${name}`).value = key;
    document.getElementById(`label-${name}`).innerText = "A&ntilde;adiendo a: " + label;
}

function sendPoints(name) {
    const key = document.getElementById(`key-${name}`).value;
    const val = document.getElementById(`val-${name}`).value;
    if(!key || !val || val <= 0) { notify('Atenci&oacute;n', 'Selecciona atributo y cantidad', 'error'); return; }
    fetch('api_add_stats.php', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify({ char: name, stat: key, points: val }) })
    .then(r => r.json()).then(data => {
        if(data.success) { notify('&Eacute;xito', 'Puntos agregados'); setTimeout(() => location.reload(), 1500); }
        else { notify('Error', data.message, 'error'); }
    });
}

function doAction(name, action) {
    if(!confirm('&iquest;Est&aacute;s seguro?')) return;
    fetch('api_char_actions.php', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify({ char: name, action: action }) })
    .then(r => r.json()).then(data => {
        if(data.success) { notify('&Eacute;xito', 'Acci&oacute;n completada'); setTimeout(() => location.reload(), 1500); }
        else { notify('Error', data.message, 'error'); }
    });
}

function uploadAvatar(i) {
    const file = i.files[0]; if(!file) return;
    const formData = new FormData(); formData.append('avatar', file);
    fetch('api_upload_avatar.php', { method: 'POST', body: formData })
    .then(r => r.json()).then(data => {
        if(data.success) { document.getElementById('user-avatar').src = data.url + '?t=' + new Date().getTime(); notify('&Eacute;xito', 'Avatar actualizado'); }
        else { notify('Error', data.message, 'error'); }
    });
}

function notify(title, msg, type = 'success') {
    const toast = document.getElementById('toast-notif');
    document.getElementById('toast-title').innerHTML = title;
    document.getElementById('toast-msg').innerHTML = msg;
    const status = document.getElementById('toast-status');
    status.className = (type === 'success') ? "w-10 h-10 rounded-full flex items-center justify-center bg-green-500/20 border border-green-500/50 text-green-500" : "w-10 h-10 rounded-full flex items-center justify-center bg-red-500/20 border border-red-500/50 text-red-500";
    if(typeof lucide !== 'undefined') lucide.createIcons();
    toast.classList.add('active');
    setTimeout(() => toast.classList.remove('active'), 4000);
}
</script>

<?php 
// Cargar el Footer dinmico
include($template_path . 'footer.php'); 
?>