<?php
// ... (Toda tu lógica PHP inicial se mantiene intacta) ...
error_reporting(0);
ini_set('display_errors', 0);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$realOnline = 0;
$vpsOnline = false;

$webTitle = "MU ONLINE - GLOBAL";
$webFavicon = "favicon.ico";
$webMetaImage = "assets/images/default-share.jpg";
$serverVersion = "S6 EP3"; 
$serverExp = "9999x";

try {
    $posible_paths = [
        __DIR__ . '/../config/settings.php',
        __DIR__ . '/config/settings.php',
        'config/settings.php'
    ];

    $configPath = "";
    foreach ($posible_paths as $path) {
        if (file_exists($path)) {
            $configPath = $path;
            break;
        }
    }

    if ($configPath !== "") {
        require_once($configPath);
        if (!isset($pdo)) {
            $dsn = "dblib:host={$db_settings['host']};dbname={$db_settings['name']};charset=UTF8";
            $pdo = new PDO($dsn, $db_settings['user'], $db_settings['pass']);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        }
        $vpsOnline = true;
        $configStmt = $pdo->query("SELECT setting_key, setting_value FROM Web_Settings");
        $webSettings = $configStmt->fetchAll(PDO::FETCH_KEY_PAIR);

        if (!empty($webSettings['web_title'])) { $webTitle = $webSettings['web_title']; }
        if (!empty($webSettings['server_version'])) { $serverVersion = $webSettings['server_version']; }
        if (!empty($webSettings['server_exp'])) { $serverExp = $webSettings['server_exp']; }
        if (!empty($webSettings['web_favicon_url'])) { $webFavicon = 'admin/' . $webSettings['web_favicon_url']; }
        if (!empty($webSettings['web_meta_url'])) { $webMetaImage = 'admin/' . $webSettings['web_meta_url']; }

        $onlineQuery = $pdo->query("SELECT COUNT(*) FROM MEMB_STAT WHERE ConnectStat = 1");
        if ($onlineQuery) { $realOnline = (int)$onlineQuery->fetchColumn(); }
    }
} catch (Exception $e) {
    $vpsOnline = false;
    $realOnline = 0;
}
?>
<!DOCTYPE html>
<html lang="es" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title><?php echo htmlspecialchars($webTitle); ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="icon" type="image/png" href="<?php echo $webFavicon; ?>?v=<?php echo time(); ?>">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400;700&family=Roboto:wght@300;400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    <script src="https://unpkg.com/lucide@latest"></script>

    <style>
        :root { 
            --accent: #ff8a3b; 
            --fire: #d74921; 
            --gold-gradient: linear-gradient(135deg, #d74921 0%, #ff8a3b 100%);
            --glass: rgba(255, 255, 255, 0.03);
            --glass-border: rgba(255, 255, 255, 0.08);
        }

        body { background-color: #050505; color: #e6d6c6; font-family: 'Roboto', sans-serif; overflow-x: hidden; width: 100%; }
        .nav-glass { background: rgba(0, 0, 0, 0.9); backdrop-filter: blur(12px); border-bottom: 1px solid var(--glass-border); }
        .stat-box { background: var(--glass); border: 1px solid var(--glass-border); backdrop-filter: blur(8px); border-radius: 10px; padding: 6px 14px; display: flex; align-items: center; gap: 10px; transition: all 0.3s ease; }
        .nav-link { font-family: 'Cinzel', serif; position: relative; transition: all 0.3s; }
        .btn-modern { background: var(--gold-gradient); position: relative; overflow: hidden; transition: all 0.3s ease; box-shadow: 0 4px 15px rgba(215, 73, 33, 0.3); display: inline-flex; align-items: center; justify-content: center; }
        .btn-modern:hover { transform: translateY(-2px); box-shadow: 0 8px 25px rgba(215, 73, 33, 0.5); filter: brightness(1.1); }
        .btn-modern::before { content: ''; position: absolute; top: 0; left: -100%; width: 100%; height: 100%; background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent); transition: 0.5s; }
        .btn-modern:hover::before { left: 100%; }
        
        /* Estilos del Menú Móvil corregidos */
        #mobile-menu {
            transform: translateX(100%);
            transition: transform 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            background: rgba(10, 10, 10, 0.98);
            backdrop-filter: blur(20px);
        }
        #mobile-menu.open { transform: translateX(0); }
        .mobile-link {
            font-family: 'Cinzel', serif;
            border-bottom: 1px solid rgba(255,255,255,0.05);
            padding: 18px 25px;
            display: flex;
            align-items: center;
            text-transform: uppercase;
            letter-spacing: 2px;
            font-size: 13px;
            color: white;
            transition: 0.3s;
        }
        .mobile-link:hover { background: rgba(215, 73, 33, 0.1); color: var(--accent); }
    </style>
</head>
<body class="animate__animated animate__fadeIn">

<nav class="fixed top-0 w-full z-[100] nav-glass h-16 md:h-20 flex items-center">
    <div class="container mx-auto px-4 md:px-6 flex justify-between items-center gap-2">
        
        <a href="index.php" class="flex-shrink-0">
            <img src="logo-balduneta.png" class="h-8 md:h-12 hover:scale-105 transition" alt="Logo">
        </a>
        
        <div class="hidden lg:flex space-x-6">
            <a href="index.php" class="nav-link text-[10px] tracking-[0.2em] uppercase hover:text-orange-500">Inicio</a>
            <a href="descargas.php" class="nav-link text-[10px] tracking-[0.2em] uppercase hover:text-orange-500">Descargas</a>
            <a href="ranking.php" class="nav-link text-[10px] tracking-[0.2em] uppercase hover:text-orange-500">Rankings</a>
            <a href="eventos.php" class="nav-link text-[10px] tracking-[0.2em] uppercase hover:text-orange-500">Eventos</a>
        </div>

        <div class="hidden md:flex items-center gap-3">
            <div class="stat-box">
                <div class="flex flex-col">
                    <span class="text-[7px] text-gray-500 uppercase font-bold tracking-widest text-center">Servidor</span>
                    <div class="flex items-center gap-2">
                        <span class="relative flex h-2 w-2">
                            <span class="animate-ping absolute inline-flex h-full w-full rounded-full <?php echo $vpsOnline ? 'bg-green-400' : 'bg-red-400'; ?> opacity-75"></span>
                            <span class="relative inline-flex rounded-full h-2 w-2 <?php echo $vpsOnline ? 'bg-green-500' : 'bg-red-500'; ?>"></span>
                        </span>
                        <span class="text-[11px] font-bold text-white">
                            <?php echo $realOnline; ?> 
                            <span class="text-[8px] text-gray-400 italic"><?php echo $vpsOnline ? 'On' : 'Off'; ?></span>
                        </span>
                    </div>
                </div>
            </div>

            <div class="stat-box">
                <div class="flex flex-col">
                    <span class="text-[7px] text-gray-500 uppercase font-bold tracking-widest text-center">Versión</span>
                    <span class="text-[11px] font-bold text-orange-500 italic uppercase text-center">
                        <?php echo htmlspecialchars($serverVersion); ?>
                    </span>
                </div>
            </div>
        </div>
        
        <div class="flex items-center gap-3">
            <a href="registro.php" class="btn-modern px-4 md:px-8 py-2 md:py-2.5 rounded text-[9px] md:text-[10px] font-title uppercase font-bold tracking-tighter md:tracking-widest text-white whitespace-nowrap flex-shrink-0">
                Registrar<span class="hidden sm:inline">&nbsp;Cuenta</span>
            </a>

            <button id="mobile-menu-btn" class="lg:hidden text-white p-2 hover:bg-white/5 rounded-lg transition">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
        </div>
    </div>
</nav>

<div id="mobile-menu" class="fixed inset-y-0 right-0 w-[280px] z-[110] lg:hidden shadow-2xl border-l border-orange-900/30">
    <div class="p-6 flex justify-between items-center border-b border-white/10 bg-black/20">
        <span class="font-title text-orange-500 text-xs tracking-widest uppercase">Menú Principal</span>
        <button id="close-menu-btn" class="text-white hover:rotate-90 transition-transform duration-300">
            <i data-lucide="x" class="w-6 h-6"></i>
        </button>
    </div>
    
    <nav class="flex flex-col mt-4">
        <a href="index.php" class="mobile-link"><i data-lucide="home" class="w-4 h-4 mr-4 text-orange-500"></i> Inicio</a>
        <a href="descargas.php" class="mobile-link"><i data-lucide="download" class="w-4 h-4 mr-4 text-orange-500"></i> Descargas</a>
        <a href="ranking.php" class="mobile-link"><i data-lucide="trophy" class="w-4 h-4 mr-4 text-orange-500"></i> Rankings</a>
        <a href="eventos.php" class="mobile-link"><i data-lucide="calendar" class="w-4 h-4 mr-4 text-orange-500"></i> Eventos</a>
    </nav>

    <div class="absolute bottom-0 w-full p-6 border-t border-white/5 bg-black/40">
        <div class="flex justify-between items-center text-[10px] uppercase tracking-widest text-gray-500">
            <span>Servidor</span>
            <span class="text-green-500"><?php echo $vpsOnline ? 'Online' : 'Offline'; ?></span>
        </div>
    </div>
</div>

<div id="menu-overlay" class="fixed inset-0 bg-black/70 backdrop-blur-sm z-[105] hidden lg:hidden"></div>

<div class="h-16 md:h-20"></div>

<script>
    lucide.createIcons();

    const mobileBtn = document.getElementById('mobile-menu-btn');
    const closeBtn = document.getElementById('close-menu-btn');
    const mobileMenu = document.getElementById('mobile-menu');
    const overlay = document.getElementById('menu-overlay');

    function toggleMenu() {
        mobileMenu.classList.toggle('open');
        overlay.classList.toggle('hidden');
        document.body.classList.toggle('overflow-hidden');
    }

    mobileBtn.addEventListener('click', toggleMenu);
    closeBtn.addEventListener('click', toggleMenu);
    overlay.addEventListener('click', toggleMenu);
</script>