<?php 
/**
 * MASTER CORE V1 - INDEX PUENTE DIN09MICO
 * Carga el template seleccionado desde el panel administrativo
 */

// 1. CARGAR CONFIGURACI07N GLOBAL
if (file_exists('config/settings.php')) {
    require_once('config/settings.php'); 
}

// 2. CARGAR CONFIGURACI07N DE TEMPLATE ACTIVO (Generado por el Panel)
// Este archivo define la constante ACTIVE_TEMPLATE
if (file_exists('active_template.php')) {
    include 'active_template.php';
} else {
    // Si no existe, definimos uno por defecto para evitar errores
    define('ACTIVE_TEMPLATE', 'Aethelgard');
}

// --- BLOQUE DE SEGURIDAD MASTER CORE (NO TOCAR) ---
$license_active = false;
$this_domain = strtolower($_SERVER['HTTP_HOST']);
$this_domain = str_replace('www.', '', $this_domain);
$this_domain = explode(':', $this_domain)[0];

if (isset($db_settings['key']) && !empty($db_settings['key'])) {
    $api_url = "https://aetherhost.com/aecms/check.php";
    
    $ch = curl_init($api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, [
        'key'    => trim($db_settings['key']), 
        'domain' => $this_domain
    ]);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $response = curl_exec($ch);
    curl_close($ch);

    if ($response) {
        $res = json_decode(trim($response), true);
        if (isset($res['status']) && strtolower($res['status']) === 'success') {
            $license_active = true;
        }
    }
}

if (!$license_active) {
    die('
    <!DOCTYPE html>
    <html lang="es">
    <head>
        <meta charset="UTF-8">
        <title>Acceso Restringido</title>
        <style>
            body { background: #050505; color: #eee; font-family: sans-serif; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
            .card { background: #0a0a0a; border: 2px solid #d74921; padding: 40px; border-radius: 10px; text-align: center; max-width: 550px; box-shadow: 0 0 30px rgba(215,73,33,0.2); border-top: 5px solid #d74921; }
            .info-text { font-size: 1.2rem; margin-bottom: 25px; line-height: 1.6; color: #ccc; }
            .domain-label { color: #d74921; font-weight: bold; font-size: 1.4rem; display: block; margin: 10px 0; border: 1px dashed #444; padding: 10px; background: #111; }
            .btn-renew { background: linear-gradient(135deg, #d74921 0%, #ff8a3b 100%); color: white; padding: 15px 35px; text-decoration: none; border-radius: 5px; font-weight: bold; display: inline-block; font-size: 1.1rem; box-shadow: 0 4px 15px rgba(215,73,33,0.4); transition: 0.3s; }
            .btn-renew:hover { transform: translateY(-3px); filter: brightness(1.1); }
        </style>
    </head>
    <body>
        <div class="card">
            <p class="info-text">Lo sentimos, pero el acceso a este sitio ha sido restringido porque no se detect&oacute; una licencia activa para el dominio: <span class="domain-label">'.$this_domain.'</span></p>
            <a href="https://aetherhost.com" class="btn-renew">RENOVAR LICENCIA AHORA</a>
        </div>
    </body>
    </html>');
}

// --- 3. L07GICA DE PUENTE HACIA EL TEMPLATE ---

// Definimos la ruta al index del template activo
$template_path = 'templates/' . ACTIVE_TEMPLATE . '/index.php';

if (file_exists($template_path)) {
    // Si el template existe, lo cargamos
    include($template_path);
} else {
    // Si el template seleccionado no existe fsicamente, mostramos un error o cargamos uno de emergencia
    die("Error Crtico: El template '" . ACTIVE_TEMPLATE . "' no existe en la carpeta /templates/.");
}
?>