<?php
// guardian.php - El Sello de Sangre de AECMS
function aecms_guardian($data) {
    if (is_array($data)) {
        foreach ($data as $key => $val) { $data[$key] = aecms_guardian($val); }
    } else {
        // Bloqueamos palabras clave de inyección SQL
        $bad_words = ["/union/i", "/select/i", "/update/i", "/delete/i", "/drop/i", "/insert/i", "/--/"];
        $data = preg_replace($bad_words, "", $data);
        // Evitamos saltos de carpeta (Directory Traversal)
        $data = str_replace(["../", "..\\"], "", $data);
        $data = htmlspecialchars($data, ENT_QUOTES, 'UTF-8');
    }
    return $data;
}

// Sanitizar todo el tráfico entrante
$_GET = aecms_guardian($_GET);
$_POST = aecms_guardian($_POST);
$_REQUEST = aecms_guardian($_REQUEST);
$_COOKIE = aecms_guardian($_COOKIE);
?>