<?php 
// 1. CARGAR CONFIGURACIÓN Y TEMPLATE ACTIVO
require_once('config/settings.php'); 
if (file_exists('active_template.php')) { 
    include 'active_template.php'; 
}

// 2. RUTA CORREGIDA: Apunta directamente a Desing dentro de tu Template
include('templates/' . ACTIVE_TEMPLATE . '/Desing/header.php'); 

try {
    $dsn = "dblib:host={$db_settings['host']};dbname={$db_settings['name']}";
    $pdo = new PDO($dsn, $db_settings['user'], $db_settings['pass']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $stmt = $pdo->query("SELECT * FROM Web_Downloads ORDER BY id DESC");
    $downloads = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $downloads = [];
}
?>

<div class="container mx-auto px-4" style="margin-top: 120px; margin-bottom: 80px;">
    <div class="max-w-5xl mx-auto text-center">
        <h1 class="text-5xl font-bold text-white mb-4 font-title tracking-tighter uppercase italic">
            Zona de <span class="text-orange-500">Descargas</span>
        </h1>
        <p class="text-gray-400 mb-12 tracking-[0.2em] text-xs uppercase">Obtén el cliente oficial y comienza tu aventura</p>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-10">
            <?php if(count($downloads) > 0): ?>
                <?php foreach($downloads as $dl): ?>
                <div class="relative group">
                    <div class="absolute -inset-0.5 bg-gradient-to-r from-orange-600 to-red-600 rounded-2xl blur opacity-20 group-hover:opacity-50 transition duration-1000"></div>
                    
                    <div class="relative bg-[#0a0a0a] border border-white/10 p-10 rounded-2xl overflow-hidden">
                        <div class="absolute -right-4 -bottom-4 text-white/5 transform rotate-12">
                            <i data-lucide="download" size="120"></i>
                        </div>

                        <div class="text-orange-500 mb-6 flex justify-center">
                            <div class="p-4 bg-orange-500/10 rounded-full">
                                <i data-lucide="download-cloud" size="40"></i>
                            </div>
                        </div>

                        <h3 class="text-2xl font-bold text-white mb-3 uppercase tracking-tighter">
                            <?php echo htmlspecialchars($dl['name']); ?>
                        </h3>

                        <p class="text-gray-400 text-sm mb-8 leading-relaxed relative z-10">
                            <?php echo !empty($dl['description']) ? htmlspecialchars($dl['description']) : "Cliente oficial actualizado. Incluye todos los parches de seguridad y sonido."; ?>
                        </p>

                        <a href="<?php echo htmlspecialchars($dl['url']); ?>" target="_blank" 
                           class="relative inline-flex items-center justify-center w-full px-8 py-4 font-bold text-white transition-all duration-200 bg-orange-600 font-title rounded-lg hover:bg-orange-700 uppercase tracking-widest text-xs">
                           <i data-lucide="external-link" class="w-4 h-4 mr-2"></i>
                           Descargar Ahora
                        </a>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-span-2 text-gray-500 italic py-20 bg-white/5 rounded-2xl border border-white/10">
                    No hay enlaces disponibles. Contacta con el staff.
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php 
// 3. FOOTER CORREGIDO: Misma ruta dentro de Desing
include('templates/' . ACTIVE_TEMPLATE . '/Desing/footer.php'); 
?>