<?php
session_start();
header('Content-Type: application/json');

// 1. Verificar Sesión
if (!isset($_SESSION['logged_in'])) {
    echo json_encode(['success' => false, 'message' => 'Sesion expirada']);
    exit;
}

require_once(__DIR__ . '/config/settings.php');

// 2. Leer datos del Frontend
$data = json_decode(file_get_contents('php://input'), true);
$charName = $data['char'] ?? '';
$statKey  = $data['stat'] ?? ''; 
$amount   = (int)($data['amount'] ?? 0);

if (!$charName || !$statKey || $amount <= 0) {
    echo json_encode(['success' => false, 'message' => 'Datos incompletos']);
    exit;
}

try {
    $host = $db_settings['host'];
    $dbname = $db_settings['name'];
    $user = $db_settings['user'];
    $pass = $db_settings['pass'];

    // 3. Conexión compatible (Detección automática de Driver)
    if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
        $pdo = new PDO("sqlsrv:Server=$host;Database=$dbname", $user, $pass);
    } else {
        $pdo = new PDO("dblib:host=$host;dbname=$dbname", $user, $pass);
    }
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // 4. Verificar puntos actuales y pertenencia
    $stmt = $pdo->prepare("SELECT LevelUpPoint FROM Character WHERE Name = ? AND AccountID = ?");
    $stmt->execute([$charName, $_SESSION['user_id']]);
    $char = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$char) {
        echo json_encode(['success' => false, 'message' => 'Personaje no encontrado']);
        exit;
    }

    if ($char['LevelUpPoint'] < $amount) {
        echo json_encode(['success' => false, 'message' => 'No tienes puntos suficientes']);
        exit;
    }

    // 5. Validar que el Stat sea correcto para evitar inyección
    $allowedStats = ['Strength', 'Dexterity', 'Vitality', 'Energy', 'Leadership'];
    if (!in_array($statKey, $allowedStats)) {
        echo json_encode(['success' => false, 'message' => 'Atributo no permitido']);
        exit;
    }

    // 6. Ejecutar el Update
    $pdo->beginTransaction();
    // Nota: LevelUpPoint es el nombre estándar en MuEmu
    $sql = "UPDATE Character SET $statKey = $statKey + ?, LevelUpPoint = LevelUpPoint - ? WHERE Name = ?";
    $update = $pdo->prepare($sql);
    $update->execute([$amount, $amount, $charName]);
    $pdo->commit();

    echo json_encode([
        'success' => true, 
        'newPoints' => ($char['LevelUpPoint'] - $amount)
    ]);

} catch (PDOException $e) {
    if (isset($pdo)) $pdo->rollBack();
    // Enviamos el mensaje real del error para saber qué pasa (luego lo puedes quitar por seguridad)
    echo json_encode(['success' => false, 'message' => 'SQL Error: ' . $e->getMessage()]);
}