<div class="glass rounded-lg overflow-hidden mb-6 w-full">
    <div class="bg-black/40 p-4 border-b border-orange-900/30 flex justify-between items-center">
        <h3 class="font-title text-orange-400 text-sm tracking-tighter uppercase">Top 5 Guerreros</h3>
        <i data-lucide="trophy" class="w-4 h-4 text-orange-400"></i>
    </div>
    <div class="p-1 md:p-2">
        <?php
        if($vpsOnline) {
            // Se asume que $pdo ya está definido en el index/header
            $top = $pdo->query("SELECT TOP 5 Name, Class, ResetCount FROM Character ORDER BY ResetCount DESC, cLevel DESC");
            $pos = 1;
            while($row = $top->fetch(PDO::FETCH_ASSOC)) {
                echo "
                <div class='flex items-center justify-between p-3 hover:bg-white/5 rounded transition group overflow-hidden'>
                    <div class='flex items-center space-x-3 min-w-0 flex-1'>
                        <span class='text-xs font-bold text-gray-500 flex-shrink-0'>0{$pos}</span>
                        <span class='text-sm font-semibold group-hover:text-orange-400 truncate text-gray-200 uppercase tracking-tighter'>".htmlspecialchars($row['Name'])."</span>
                    </div>
                    <div class='flex-shrink-0 ml-2 text-right'>
                        <span class='text-[10px] md:text-xs font-title text-orange-500 whitespace-nowrap'>{$row['ResetCount']} RESETS</span>
                    </div>
                </div>";
                $pos++;
            }
        } else {
            echo "<div class='p-6 text-center'><p class='text-[10px] text-gray-500 uppercase italic'>Servidor Offline</p></div>";
        }
        ?>
    </div>
    <a href="ranking.php" class="block text-center p-3 text-[9px] font-title text-gray-500 hover:text-orange-400 border-t border-white/5 transition-colors uppercase tracking-widest">
        Ver ranking completo
    </a>
</div>