<?php
// Conexión y consulta a la DB
try {
    $stmt = $pdo->query("SELECT * FROM Web_News ORDER BY created_at DESC");
    $allNews = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $allNews = [];
}
?>

<div class="mb-10">
    <div class="flex items-center justify-between mb-8">
        <h2 class="font-title text-3xl bg-gradient-to-r from-orange-600 to-yellow-500 bg-clip-text text-transparent uppercase tracking-tighter italic">
            Últimas Noticias
        </h2>
    </div>

    <div class="space-y-8"> 
        <?php if (!empty($allNews)): ?>
            <?php foreach ($allNews as $index => $news): 
                $hasImage = !empty($news['image_url']);
                $content = $news['content'];
                // Definimos un límite para decidir si mostrar el botón
                $isLong = strlen(strip_tags($content)) > 200;
            ?>
            
            <div class="relative group overflow-hidden rounded-2xl border border-orange-900/20 shadow-2xl transition-all duration-500 
                <?php echo $hasImage ? 'min-h-[400px]' : 'bg-gradient-to-br from-[#0a0a0a] to-[#111] py-12 border-l-4 border-l-orange-600'; ?>">
                
                <?php if ($hasImage): ?>
                    <img src="<?php echo $news['image_url']; ?>" 
                         class="absolute inset-0 w-full h-full object-cover transition-transform duration-700 group-hover:scale-110"
                         alt="<?php echo $news['title']; ?>">
                         
                    <div class="absolute inset-0 bg-gradient-to-t from-[#050505] via-[#050505]/40 to-transparent"></div>
                <?php else: ?>
                    <div class="absolute top-0 right-0 w-64 h-64 bg-orange-600/5 blur-[100px] rounded-full"></div>
                <?php endif; ?>
                     
                <div class="<?php echo $hasImage ? 'relative mt-auto pt-40 p-8' : 'relative px-12'; ?> z-10 w-full">
                    <div class="flex items-center gap-3 mb-4">
                        <span class="bg-orange-600 text-white text-[10px] font-bold px-3 py-1 rounded-full uppercase">
                            <?php echo $news['category']; ?>
                        </span>
                        <span class="text-gray-400 text-[10px] font-bold uppercase tracking-widest">
                            <?php echo date('d/m/Y', strtotime($news['created_at'])); ?>
                        </span>
                    </div>
                    
                    <h3 class="font-title <?php echo $hasImage ? 'text-3xl' : 'text-4xl'; ?> text-white mb-4 tracking-tight">
                        <?php echo $news['title']; ?>
                    </h3>
                    
                    <div id="news-content-<?php echo $index; ?>" 
                         class="news-text text-gray-400 text-sm leading-relaxed overflow-hidden transition-all duration-500 max-h-20"
                         style="<?php echo $hasImage ? 'max-w-xl' : 'max-w-3xl'; ?>">
                        <?php echo nl2br($content); ?>
                    </div>

                    <?php if ($isLong): ?>
                        <button onclick="toggleNews(<?php echo $index; ?>)" 
                                id="btn-<?php echo $index; ?>"
                                class="mt-6 flex items-center text-orange-500 text-[10px] font-bold uppercase tracking-[0.2em] hover:gap-3 transition-all cursor-pointer bg-transparent border-none p-0">
                            <span class="btn-text">Leer artículo completo</span> <span class="ml-2">↓</span>
                        </button>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="p-16 border border-dashed border-white/5 rounded-3xl text-center bg-[#050505]">
                <p class="text-gray-600 italic uppercase text-xs">No hay anuncios oficiales por el momento.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
function toggleNews(id) {
    const content = document.getElementById('news-content-' + id);
    const btnText = document.querySelector('#btn-' + id + ' .btn-text');
    const btnIcon = document.querySelector('#btn-' + id + ' span:last-child');

    if (content.style.maxHeight === '1000px') {
        content.style.maxHeight = '5rem'; // Equivale a max-h-20
        btnText.innerText = 'Leer artículo completo';
        btnIcon.innerText = '↓';
    } else {
        content.style.maxHeight = '1000px'; // Se expande
        btnText.innerText = 'Ver menos';
        btnIcon.innerText = '↑';
    }
}
</script>

<style>
.news-text {
    display: -webkit-box;
    -webkit-line-clamp: 3; /* Número de líneas visibles inicialmente */
    -webkit-box-orient: vertical;
}
.news-text[style*="max-height: 1000px"] {
    -webkit-line-clamp: unset;
}
</style>