<?php 
if (session_status() === PHP_SESSION_NONE) { @session_start(); }

// Cargamos la configuración para obtener el nombre del admin definido en el setup
require_once(__DIR__ . '/../config/settings.php');
$masterAdmin = $db_settings['admin_user'] ?? 'Admin';
?>
<div class="p-8">
    <?php if (isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true): ?>
        
        <div class="text-center animate__animated animate__fadeIn">
            <?php $is_staff = ($_SESSION['user_id'] === $masterAdmin); ?>

            <div class="w-20 h-20 <?php echo $is_staff ? 'bg-red-500/10 border-red-500/30' : 'bg-orange-500/10 border-orange-500/30'; ?> rounded-full flex items-center justify-center mx-auto mb-4 border transition-all duration-500">
                <i data-lucide="<?php echo $is_staff ? 'shield-check' : 'user-check'; ?>" 
                   class="<?php echo $is_staff ? 'text-red-500 animate-pulse' : 'text-orange-500'; ?> w-10 h-10"></i>
            </div>
            
            <p class="text-[10px] text-gray-500 uppercase font-title tracking-[0.2em] mb-1">
                <?php echo $is_staff ? 'Rango Administrativo' : 'Guerrero Conectado'; ?>
            </p>
            <h3 class="text-xl font-bold text-white mb-6 tracking-tighter uppercase"><?php echo $_SESSION['user_id']; ?></h3>

            <div class="space-y-3">
                <?php if ($is_staff): ?>
                    <a href="admin/index.php" class="btn-admin block py-3 rounded-xl font-bold uppercase text-[11px] text-white tracking-[0.2em] mb-4">
                        <i data-lucide="settings" class="inline-block w-4 h-4 mr-2 -mt-1"></i>
                        Panel Administrativo
                    </a>
                <?php endif; ?>

                <a href="panel.php" class="btn-modern block py-3 rounded-xl font-bold uppercase text-[11px] text-white tracking-widest">
                    Panel de Usuario
                </a>
                
                <a href="logout.php" class="flex items-center justify-center gap-2 py-2 text-[9px] text-gray-500 hover:text-red-500 uppercase transition tracking-widest font-bold mt-4">
                    <i data-lucide="log-out" class="w-3 h-3"></i>
                    Cerrar Sesión
                </a>
            </div>
        </div>

    <?php else: ?>
        <h3 class="text-lg font-title text-orange-500 mb-6 text-center tracking-widest uppercase">Iniciar Sesión</h3>
        <form action="login_process.php" method="POST" class="space-y-4">
            <div class="relative">
                <i data-lucide="user" class="absolute left-4 top-1/2 -translate-y-1/2 w-4 h-4 text-gray-500"></i>
                <input type="text" name="user" placeholder="USUARIO" required 
                    class="w-full bg-black/50 border border-white/10 rounded-xl px-12 py-3 text-xs text-white focus:border-orange-500 outline-none transition-all">
            </div>
            <div class="relative">
                <i data-lucide="lock" class="absolute left-4 top-1/2 -translate-y-1/2 w-4 h-4 text-gray-500"></i>
                <input type="password" name="pass" placeholder="CONTRASEÑA" required 
                    class="w-full bg-black/50 border border-white/10 rounded-xl px-12 py-3 text-xs text-white focus:border-orange-500 outline-none transition-all">
            </div>
            <button type="submit" class="btn-modern w-full py-4 rounded-xl font-bold text-white uppercase tracking-[0.2em] text-[10px]">
                ACCEDER
            </button>
        </form>
    <?php endif; ?>
</div>

<style>
    .btn-admin {
        background: linear-gradient(135deg, #720917 0%, #b91c1c 100%);
        border: 1px solid rgba(220, 38, 38, 0.4);
        box-shadow: 0 4px 15px rgba(114, 9, 23, 0.4);
        position: relative; overflow: hidden; transition: 0.3s;
    }
    .btn-admin:hover { transform: translateY(-2px) scale(1.02); filter: brightness(1.2); box-shadow: 0 8px 20px rgba(185, 28, 28, 0.5); }
    .btn-admin::after { content: ''; position: absolute; top: 0; left: -100%; width: 100%; height: 100%; background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent); transition: 0.6s; }
    .btn-admin:hover::after { left: 100%; }
</style>
<script>lucide.createIcons();</script>