<section class="relative h-[85vh] flex items-center justify-center overflow-hidden">
    <div class="absolute inset-0 z-0">
        <video autoplay muted loop playsinline class="w-full h-full object-cover opacity-40">
            <source src="video/bg.mp4" type="video/mp4">
            <source src="https://assets.mixkit.co/videos/preview/mixkit-fire-flames-flickering-in-the-dark-42805-large.mp4" type="video/mp4">
        </video>
        
        <div class="absolute inset-0" style="background: linear-gradient(0deg, #050505 0%, rgba(5,5,5,0.4) 50%, transparent 100%);"></div>
    </div>

    <div class="relative z-10 text-center px-4 w-full max-w-4xl">
        <img src="logo-balduneta.png" alt="Logo" class="mx-auto w-full max-w-md drop-shadow-[0_0_35px_rgba(215,73,33,0.5)] mb-8 animate-pulse" style="animation-duration: 4s;">
        
        <h1 class="font-title text-2xl md:text-4xl text-yellow-500 tracking-[0.2em] mb-12 text-glow italic">
            BIENVENIDOS A LA NUEVA ERA
        </h1>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 max-w-2xl mx-auto mt-12">
            
            <a href="descargas.php" class="hero-zoom-card group">
                <div class="flex flex-col items-center relative z-10">
                    <p class="text-[10px] uppercase tracking-[0.3em] text-orange-500/80 mb-2 font-title">Cliente Oficial</p>
                    <div class="flex items-center gap-4">
                        <i data-lucide="download-cloud" class="w-7 h-7 text-white group-hover:text-orange-500 transition-colors duration-300"></i>
                        <span class="text-2xl font-bold text-white uppercase tracking-tighter">Descargas</span>
                    </div>
                </div>
                <div class="absolute inset-0 bg-gradient-to-br from-white/5 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
            </a>

            <div class="hero-zoom-card cursor-default group">
                <div class="flex flex-col items-center relative z-10">
                    <p class="text-[10px] uppercase tracking-[0.3em] text-gray-500 mb-2 font-title">Servidor Global</p>
                    <div class="flex items-center gap-4">
                        <i data-lucide="zap" class="w-7 h-7 text-yellow-500 animate-pulse"></i>
                        <span class="text-2xl font-bold text-white uppercase tracking-tighter">
                            Exp: <span class="text-orange-500"><?php echo htmlspecialchars($serverExp); ?></span>
                        </span>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

<style>
    .hero-zoom-card {
        position: relative;
        background: rgba(0, 0, 0, 0.65);
        backdrop-filter: blur(12px);
        -webkit-backdrop-filter: blur(12px);
        border: 1px solid rgba(255, 255, 255, 0.08);
        border-radius: 20px;
        padding: 2.5rem 2rem;
        display: flex;
        overflow: hidden;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        will-change: transform;
        transition: transform 0.4s cubic-bezier(0.2, 1, 0.3, 1), 
                    background 0.4s ease, 
                    border-color 0.4s ease,
                    box-shadow 0.4s ease;
        text-decoration: none;
    }

    .hero-zoom-card:hover {
        transform: scale(1.08);
        background: rgba(0, 0, 0, 0.8);
        border-color: rgba(255, 138, 59, 0.4);
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.6), 
                    0 0 25px rgba(215, 73, 33, 0.15);
        z-index: 20;
    }

    .text-glow {
        text-shadow: 0 0 20px rgba(234, 179, 8, 0.4);
    }

    .hero-zoom-card i {
        filter: drop-shadow(0 0 8px rgba(0,0,0,0.5));
    }
</style>