<?php
// Forzar la carga de datos actualizados desde la DB para el footer
try {
    if (!isset($pdo)) {
        require_once(__DIR__ . '/config/settings.php'); 
        $dsn = "dblib:host={$db_settings['host']};dbname={$db_settings['name']};charset=UTF8";
        $pdo = new PDO($dsn, $db_settings['user'], $db_settings['pass']);
    }
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM Web_Settings");
    $db_conf = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
} catch (Exception $e) {
    if(!isset($db_conf)) $db_conf = [];
}
?>

<footer class="mt-20 border-t border-orange-900/20 bg-black/40 py-12">
    <div class="container mx-auto px-6 text-center">
        <img src="logo-balduneta.png" class="h-12 mx-auto mb-6 opacity-50 grayscale hover:grayscale-0 transition">
        <p class="text-xs text-gray-600 font-title tracking-widest">
            &copy; 2026 MU ENGINE - TODOS LOS DERECHOS RESERVADOS
        </p>
        <div class="flex justify-center space-x-6 mt-6">
            <a href="<?php echo $db_conf['social_facebook'] ?? '#'; ?>" target="_blank" class="text-gray-600 hover:text-blue-500 transition">
                <i data-lucide="facebook"></i>
            </a>

            <a href="<?php echo $db_conf['social_discord'] ?? '#'; ?>" target="_blank" class="text-gray-600 hover:text-[#5865F2] transition text-xl">
                <i class="fa-brands fa-discord"></i>
            </a>

            <a href="<?php echo $db_conf['social_youtube'] ?? '#'; ?>" target="_blank" class="text-gray-600 hover:text-red-500 transition">
                <i data-lucide="youtube"></i>
            </a>
        </div>
    </div>
</footer>

<script>
    // Inicializar iconos de Lucide
    lucide.createIcons();

    // Efecto de Scroll para el Navbar
    window.addEventListener('scroll', function() {
        const nav = document.querySelector('nav');
        if (nav) {
            if (window.scrollY > 100) {
                nav.style.background = "rgba(0, 0, 0, 0.95)";
                nav.style.height = "60px";
            } else {
                nav.style.background = "rgba(0, 0, 0, 0.6)";
                nav.style.height = "70px";
            }
        }
    });
</script>

<script>
    // Inicializar iconos
    lucide.createIcons();

    // Efecto de transicin suave al hacer clic en links
    document.querySelectorAll('a').forEach(link => {
        link.addEventListener('click', e => {
            const href = link.getAttribute('href');
            if (href && href.includes('.php') && !href.startsWith('http')) {
                e.preventDefault();
                document.body.style.opacity = '0';
                document.body.style.transition = 'opacity 0.4s ease';
                setTimeout(() => {
                    window.location.href = href;
                }, 400);
            }
        });
    });

    // Control del Navbar al hacer Scroll
    window.addEventListener('scroll', () => {
        const nav = document.querySelector('nav');
        if (nav) {
            if (window.scrollY > 50) {
                nav.classList.add('h-16', 'bg-black');
                nav.classList.remove('h-20');
            } else {
                nav.classList.add('h-20');
                nav.classList.remove('h-16', 'bg-black');
            }
        }
    });
</script>
</body>
</html>