<?php
require_once('config/settings.php');

// Supongamos que en tu panel configuraste: 1 Dólar = 100 Monedas
$stmt = $pdo->query("SELECT setting_value FROM Web_Settings WHERE setting_key = 'coin_rate'");
$coin_rate = $stmt->fetchColumn() ?: 100; 

// El monto que quieres cobrar (puedes hacerlo dinámico con un select)
$monto_usd = 10; 
$monedas_a_recibir = $monto_usd * $coin_rate;
?>

<script src="https://www.paypal.com/sdk/js?client-id=TU_CLIENT_ID_AQUI&currency=USD"></script>

<div class="glass-card p-6 text-center">
    <h3 class="text-xl font-bold">Comprar <?php echo $monedas_a_recibir; ?> Monedas</h3>
    <p class="mb-4">Costo: $<?php echo $monto_usd; ?> USD</p>
    
    <div id="paypal-button-container"></div>
</div>

<script>
    paypal.Buttons({
        createOrder: function(data, actions) {
            return actions.order.create({
                purchase_units: [{
                    amount: { value: '<?php echo $monto_usd; ?>' }
                }]
            });
        },
        onApprove: function(data, actions) {
            return actions.order.capture().then(function(details) {
                // Cuando el pago se completa, avisamos a nuestro PHP
                window.location.href = "finalizar_pago.php?orderID=" + data.orderID;
            });
        }
    }).render('#paypal-button-container');
</script>