<?php
require_once(__DIR__ . '/../config/settings.php');
header('Content-Type: application/json');

try {
    $dsn = "dblib:host={$db_settings['host']};dbname={$db_settings['name']};charset=UTF8";
    $pdo = new PDO($dsn, $db_settings['user'], $db_settings['pass']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // 1. Mapeamos lo que viene del FormData (Texto)
    $settings = [
        'web_title'       => $_POST['web_title'] ?? null,
        'server_version'  => $_POST['server_version'] ?? null,
        'server_exp'      => $_POST['server_exp'] ?? null,
        'social_facebook' => $_POST['social_facebook'] ?? null,
        'social_discord'  => $_POST['social_discord'] ?? null,
        'social_youtube'  => $_POST['social_youtube'] ?? null,
        'welcome_zen'     => $_POST['welcome_zen'] ?? null
    ];

    foreach ($settings as $key => $value) {
        if ($value === null) continue;

        $update = $pdo->prepare("UPDATE Web_Settings SET setting_value = ? WHERE setting_key = ?");
        $update->execute([$value, $key]);

        if ($update->rowCount() == 0) {
            $check = $pdo->prepare("SELECT COUNT(*) FROM Web_Settings WHERE setting_key = ?");
            $check->execute([$key]);
            if ($check->fetchColumn() == 0) {
                $insert = $pdo->prepare("INSERT INTO Web_Settings (setting_key, setting_value) VALUES (?, ?)");
                $insert->execute([$key, $value]);
            }
        }
    }

    // 2. NUEVA L07GICA: Procesar Archivos (Logo, Favicon, Meta)
    $filesToProcess = [
        'web_logo_file'    => 'web_logo_url',
        'web_favicon_file' => 'web_favicon_url',
        'web_meta_file'    => 'web_meta_url'
    ];

    $uploadDir = __DIR__ . '/../uploads/';
    if (!is_dir($uploadDir)) { mkdir($uploadDir, 0777, true); }

    foreach ($filesToProcess as $postKey => $dbKey) {
        if (isset($_FILES[$postKey]) && $_FILES[$postKey]['error'] === UPLOAD_ERR_OK) {
            $file = $_FILES[$postKey];
            $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
            
            // Generamos el nombre con nmeros aleatorios (timestamp) como lo tenas antes
            $prefix = str_replace('_file', '', $postKey);
            $newName = $prefix . "_" . time() . "." . $ext;
            $uploadPath = $uploadDir . $newName;

            if (move_uploaded_file($file['tmp_name'], $uploadPath)) {
                $finalPath = 'uploads/' . $newName;
                
                // Actualizamos la ruta en la base de datos
                $updateFile = $pdo->prepare("UPDATE Web_Settings SET setting_value = ? WHERE setting_key = ?");
                $updateFile->execute([$finalPath, $dbKey]);
                
                // Si la llave no existe en la DB, la insertamos
                if ($updateFile->rowCount() == 0) {
                    $insertFile = $pdo->prepare("INSERT INTO Web_Settings (setting_key, setting_value) VALUES (?, ?)");
                    $insertFile->execute([$dbKey, $finalPath]);
                }
            }
        }
    }

    echo json_encode(['status' => 'success']);

} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}