<?php
session_start();
require_once(__DIR__ . '/../config/settings.php');
header('Content-Type: application/json');

// Seguridad: Solo el admin accede
$masterAdmin = $db_settings['admin_user'] ?? 'Admin';
if (!isset($_SESSION['logged_in']) || $_SESSION['user_id'] !== $masterAdmin) {
    echo json_encode(['status' => 'error', 'message' => 'No autorizado']);
    exit;
}

try {
    $dsn = "dblib:host={$db_settings['host']};dbname={$db_settings['name']};charset=UTF8";
    $pdo = new PDO($dsn, $db_settings['user'], $db_settings['pass']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // En lugar de una lista fija, procesamos TODO lo que viene por $_POST
    // Esto incluye: show_resets, show_mresets, show_gens, show_bc, show_ds, show_cc, show_it, show_duels, etc.
    foreach ($_POST as $key => $value) {
        
        // Limpiamos los datos básicos
        $setting_key = filter_var($key, FILTER_SANITIZE_STRING);
        $setting_value = filter_var($value, FILTER_SANITIZE_STRING);

        // Usamos la lógica UPSERT: Si existe actualiza, si no existe inserta.
        // Esto garantiza que si agregamos rankings nuevos en el futuro, el panel los guarde solo.
        $sql = "IF EXISTS (SELECT 1 FROM Web_Ranking_Config WHERE setting_key = :key)
                UPDATE Web_Ranking_Config SET setting_value = :val WHERE setting_key = :key2
                ELSE
                INSERT INTO Web_Ranking_Config (setting_key, setting_value) VALUES (:key3, :val2)";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':key'   => $setting_key,
            ':val'   => $setting_value,
            ':key2'  => $setting_key,
            ':key3'  => $setting_key,
            ':val2'  => $setting_value
        ]);
    }

    echo json_encode(['status' => 'success']);
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}