<?php
session_start();
require_once(__DIR__ . '/../config/settings.php');

/**
 * Backend: Guardar o Actualizar Noticia
 */

// SEGURIDAD: Solo el admin puede ejecutar este archivo
$masterAdmin = $db_settings['admin_user'] ?? 'Admin';
if (!isset($_SESSION['logged_in']) || $_SESSION['user_id'] !== $masterAdmin) {
    header('Content-Type: application/json');
    echo json_encode(['status' => 'error', 'message' => 'Acceso denegado']);
    exit;
}

// Recibir datos vía POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
    
    // Capturamos el ID si viene (para edición)
    $id       = $_POST['id'] ?? null; 
    $title    = $_POST['title'] ?? '';
    $category = $_POST['category'] ?? 'Noticias';
    
    // En tu JS el campo se llama 'image', asegúrate que coincida aquí
    $img_url  = !empty($_POST['image']) ? $_POST['image'] : ''; 
    $content  = $_POST['content'] ?? ''; 

    // Validamos solo lo estrictamente necesario
    if (empty($title) || empty($content)) {
        echo json_encode(['status' => 'error', 'message' => 'El título y el contenido son obligatorios']);
        exit;
    }

    try {
        $dsn = "dblib:host={$db_settings['host']}:1433;dbname={$db_settings['name']};charset=UTF8";
        $pdo = new PDO($dsn, $db_settings['user'], $db_settings['pass']);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        if (!empty($id)) {
            // --- MODO EDICIÓN (UPDATE) ---
            $sql = "UPDATE Web_News 
                    SET title = :title, 
                        content = :content, 
                        category = :category, 
                        image_url = :image_url 
                    WHERE id = :id";
            
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                ':title'     => $title,
                ':content'   => $content,
                ':category'  => $category,
                ':image_url' => $img_url,
                ':id'        => $id
            ]);
            $message = '¡Noticia actualizada con éxito!';
        } else {
            // --- MODO NUEVO (INSERT) ---
            $sql = "INSERT INTO Web_News (title, content, category, image_url, created_at) 
                    VALUES (:title, :content, :category, :image_url, GETDATE())";
            
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                ':title'     => $title,
                ':content'   => $content,
                ':category'  => $category,
                ':image_url' => $img_url
            ]);
            $message = '¡Noticia publicada con éxito!';
        }

        echo json_encode([
            'status' => 'success', 
            'message' => $message
        ]);

    } catch (Exception $e) {
        echo json_encode([
            'status' => 'error', 
            'message' => 'Error en la DB: ' . $e->getMessage()
        ]);
    }
}
?>