<?php
// save_coin_config.php
header('Content-Type: application/json');

// Definimos la ruta de la carpeta y del archivo final
$folder = __DIR__ . '/../config';
$file = $folder . '/coin_settings.php';

try {
    // 1. VERIFICACIÓN Y CREACIÓN DE CARPETA
    // Si la carpeta 'config' no existe, la creamos con permisos de escritura
    if (!file_exists($folder)) {
        if (!mkdir($folder, 0777, true)) {
            throw new Exception("No se pudo crear la carpeta 'config'. Revisa los permisos de tu hosting.");
        }
    }

    // 2. PREPARACIÓN DE LOS DATOS
    // Recogemos lo que viene del formulario de index.php
    $coin_name         = $_POST['coin_name'] ?? 'WCoins';
    $coin_table        = $_POST['coin_table'] ?? 'MEMB_INFO';
    $coin_column       = $_POST['coin_column'] ?? 'cspoints';
    $coin_id_column    = $_POST['coin_id_column'] ?? 'memb___id';
    $coin_check_online = $_POST['coin_check_online'] ?? '0';

    // Creamos el contenido del archivo PHP que se va a generar automáticamente
    $php_content = "<?php\n";
    $php_content .= "// Archivo de configuración generado automáticamente por el Panel Master Core\n";
    $php_content .= "\$coin_config = [\n";
    $php_content .= "    'coin_name' => '" . addslashes($coin_name) . "',\n";
    $php_content .= "    'coin_table' => '" . addslashes($coin_table) . "',\n";
    $php_content .= "    'coin_column' => '" . addslashes($coin_column) . "',\n";
    $php_content .= "    'coin_id_column' => '" . addslashes($coin_id_column) . "',\n";
    $php_content .= "    'coin_check_online' => '" . addslashes($coin_check_online) . "',\n";
    $php_content .= "];\n";

    // 3. CREACIÓN DEL ARCHIVO
    // Escribimos el archivo en la ruta especificada. Si no existe, lo crea. Si existe, lo sobrescribe con los nuevos datos.
    if (file_put_contents($file, $php_content) === false) {
        throw new Exception("No se pudo escribir el archivo 'coin_settings.php'. Revisa los permisos de escritura.");
    }

    // Si todo sale bien, respondemos éxito al panel
    echo json_encode(['status' => 'success', 'message' => 'Configuración creada correctamente en ' . $file]);

} catch (Exception $e) {
    // Si hay algún error (como permisos de carpeta), lo enviamos al panel
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}