<?php
error_reporting(E_ALL);
ini_set('display_errors', 0);

$target_folder = '..' . DIRECTORY_SEPARATOR . 'templates' . DIRECTORY_SEPARATOR;
$config_file = '..' . DIRECTORY_SEPARATOR . 'active_template.php';

if (!is_dir($target_folder)) {
    mkdir($target_folder, 0777, true);
}

$action = $_GET['action'] ?? '';
header('Content-Type: application/json');

switch ($action) {
    case 'upload':
        if (!isset($_FILES['template_zip'])) {
            echo json_encode(['status' => 'error', 'message' => 'No se recibió el archivo']);
            exit;
        }

        $file = $_FILES['template_zip'];
        $temp_zip = $target_folder . 'temp_package.zip';

        if (move_uploaded_file($file['tmp_name'], $temp_zip)) {
            echo json_encode(['status' => 'success', 'filename' => 'temp_package.zip']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Error al mover el archivo a: ' . $target_folder]);
        }
        break;

    case 'install':
        $zip_path = $target_folder . 'temp_package.zip';

        if (!file_exists($zip_path)) {
            echo json_encode(['status' => 'error', 'message' => 'El archivo ZIP no se encontró']);
            exit;
        }

        if (!class_exists('ZipArchive')) {
            echo json_encode(['status' => 'error', 'message' => 'ZipArchive no habilitado en el servidor']);
            exit;
        }

        $zip = new ZipArchive;
        if ($zip->open($zip_path) === TRUE) {
            $zip->extractTo($target_folder);
            $zip->close();
            unlink($zip_path); 
            echo json_encode(['status' => 'success']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'No se pudo extraer el archivo']);
        }
        break;

    case 'list':
        $items = array_filter(glob($target_folder . '*'), 'is_dir');
        $templates = array_map('basename', $items);
        echo json_encode(array_values($templates));
        break;

    case 'activate':
        $name = $_GET['name'] ?? '';
        if (!empty($name)) {
            $content = "<?php\n// Archivo autogenerado - Template Activo\ndefine('ACTIVE_TEMPLATE', '" . addslashes($name) . "');\n?>";
            if (file_put_contents($config_file, $content)) {
                echo json_encode(['status' => 'success', 'message' => 'Template ' . $name . ' seleccionado']);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'No se pudo guardar la configuración']);
            }
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Nombre de template no válido']);
        }
        break;

    default:
        echo json_encode(['status' => 'error', 'message' => 'Acción no válida']);
        break;
}