<?php
require_once(__DIR__ . '/../config/settings.php');
header('Content-Type: application/json');

try {
    $dsn = "dblib:host={$db_settings['host']};dbname={$db_settings['name']};charset=UTF8";
    $pdo = new PDO($dsn, $db_settings['user'], $db_settings['pass']);
    
    // Traemos todas las configuraciones de la tabla
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM Web_Settings");
    $config = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);

    // Si no existen las llaves, devolvemos strings vacos para evitar errores en JS
    $response = [
        'web_title'       => $config['web_title'] ?? '',
        'server_version'  => $config['server_version'] ?? '',
        'server_exp'      => $config['server_exp'] ?? '',
        'social_facebook' => $config['social_facebook'] ?? '',
        'social_discord'  => $config['social_discord'] ?? '',
        'social_youtube'  => $config['social_youtube'] ?? '',
        'web_favicon_url' => $config['web_favicon_url'] ?? '',
        'web_meta_url'    => $config['web_meta_url'] ?? '',
        'welcome_zen'     => $config['welcome_zen'] ?? '0'
    ];

    echo json_encode($response);
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}