<?php
/**
 * Lector de Configuración Universal - Master Core
 * Entrega los datos de Web_Settings en formato JSON
 */
header('Content-Type: application/json');
require_once(__DIR__ . '/../config/settings.php');

try {
    $dsn = "dblib:host={$db_settings['host']};dbname={$db_settings['name']};charset=UTF8";
    $pdo = new PDO($dsn, $db_settings['user'], $db_settings['pass']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Obtenemos todos los pares llave/valor de la tabla
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM Web_Settings");
    $settings = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);

    // Enviamos los datos al panel
    echo json_encode($settings);
} catch (Exception $e) {
    // Si hay error o la tabla está vacía, enviamos un array vacío para no romper el JS
    echo json_encode([]);
}