<?php
header('Content-Type: application/json');
require_once(__DIR__ . '/../config/settings.php');

try {
    $dsn = "dblib:host={$db_settings['host']};dbname={$db_settings['name']};charset=UTF8";
    $pdo = new PDO($dsn, $db_settings['user'], $db_settings['pass']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $stmt = $pdo->query("SELECT setting_key, setting_value FROM Web_Ranking_Config");
    $config = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
    
    // Forzamos que los valores sean devueltos como strings limpios
    echo json_encode($config ?: new stdClass());
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}