<?php
session_start();
require_once(__DIR__ . '/../config/settings.php');
$masterAdmin = $db_settings['admin_user'] ?? 'Admin';

header('Content-Type: application/json');

// Verificación de seguridad
if (!isset($_SESSION['logged_in']) || $_SESSION['user_id'] !== $masterAdmin) {
    echo json_encode(['status' => 'error', 'message' => 'No autorizado']);
    exit;
}

try {
    $dsn = "dblib:host={$db_settings['host']};dbname={$db_settings['name']};charset=UTF8";
    $pdo = new PDO($dsn, $db_settings['user'], $db_settings['pass']);
    
    // Buscamos todas las configuraciones que empiecen con 'paypal_'
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM Web_Settings WHERE setting_key LIKE 'paypal_%'");
    $config = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
    
    echo json_encode($config);
} catch (Exception $e) {
    echo json_encode([]);
}