<?php
/**
 * Backend: Obtener una noticia específica para editar
 * Ruta: admin/get_news_item.php
 */
require_once(__DIR__ . '/../config/settings.php');
header('Content-Type: application/json');

$id = $_GET['id'] ?? 0;

try {
    $dsn = "dblib:host={$db_settings['host']}:1433;dbname={$db_settings['name']};charset=UTF8";
    $pdo = new PDO($dsn, $db_settings['user'], $db_settings['pass']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Seleccionamos todos los campos necesarios para el editor
    $stmt = $pdo->prepare("SELECT id, title, category, content, image_url FROM Web_News WHERE id = ?");
    $stmt->execute([$id]);
    $item = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($item) {
        echo json_encode($item);
    } else {
        echo json_encode(['error' => 'Noticia no encontrada']);
    }

} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}