<?php
/**
 * Backend: Obtener lista de noticias
 * Ruta: admin/get_news.php
 */
require_once(__DIR__ . '/../config/settings.php');
header('Content-Type: application/json');

try {
    // Conexión usando los datos del settings.php
    $dsn = "dblib:host={$db_settings['host']}:1433;dbname={$db_settings['name']};charset=UTF8";
    $pdo = new PDO($dsn, $db_settings['user'], $db_settings['pass']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Consultamos las noticias ordenadas por la más reciente
    $stmt = $pdo->query("SELECT id, title, category, created_at FROM Web_News ORDER BY id DESC");
    $news = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($news);

} catch (Exception $e) {
    // En caso de error, devolvemos un array vacío para no romper el JS
    echo json_encode([]);
}