<?php
/**
 * Backend: Eliminar noticia (Corregido para GET)
 * Ruta: admin/delete_news.php
 */
require_once(__DIR__ . '/../config/settings.php');
header('Content-Type: application/json');

// Cambiamos la validación para que acepte el ID por la URL (GET)
if (isset($_GET['id'])) {
    try {
        $id = intval($_GET['id']);
        
        $dsn = "dblib:host={$db_settings['host']}:1433;dbname={$db_settings['name']};charset=UTF8";
        $pdo = new PDO($dsn, $db_settings['user'], $db_settings['pass']);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Importante: Si esto no borra, verifica si tu columna se llama 'id' o 'news_id'
        $stmt = $pdo->prepare("DELETE FROM Web_News WHERE id = :id");
        $stmt->execute([':id' => $id]);

        if ($stmt->rowCount() > 0) {
            echo json_encode(['status' => 'success', 'message' => 'Noticia incinerada correctamente.']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'No se encontró ninguna noticia con ese ID.']);
        }

    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => 'Error de Base de Datos: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invocación del Reino no válida: Falta el ID.']);
}