<?php
session_start();
require_once(__DIR__ . '/../config/settings.php');
header('Content-Type: application/json');

// Seguridad: Solo el admin accede
$masterAdmin = $db_settings['admin_user'] ?? 'Admin';
if (!isset($_SESSION['logged_in']) || $_SESSION['user_id'] !== $masterAdmin) {
    echo json_encode(['status' => 'error', 'message' => 'No autorizado']);
    exit;
}

if (isset($_GET['id'])) {
    try {
        $dsn = "dblib:host={$db_settings['host']};dbname={$db_settings['name']};charset=UTF8";
        $pdo = new PDO($dsn, $db_settings['user'], $db_settings['pass']);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $id = (int)$_GET['id'];
        
        // Asumiendo que tu tabla se llama Web_Downloads
        $stmt = $pdo->prepare("DELETE FROM Web_Downloads WHERE id = :id");
        $stmt->execute([':id' => $id]);

        echo json_encode(['status' => 'success']);
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'ID no proporcionado']);
}